Name: cups
Version: 1.6.2
Release: alt3.0.M70P.2

Summary: Common Unix Printing System - server package
License: GPL
Group: System/Servers

Url: http://www.cups.org

Source: ftp://ftp.easysw.com/pub/cups/%version/%name-%version.tar

Source100: %name.control
Source101: %name.pam
Source102: %name.alternatives
Source103: %name.startup
Source104: %name.xinetd
Source105: %name.modprobe
Source110: %name.systemd.path
Source111: %name.systemd.service
Source112: %name.systemd.socket
Source113: %name.systemd.tmpfiles
Source114: %name-alt-locale.tar

Patch1: cups-1.6.0-debian-pidfile.patch
Patch2: cups-1.6.1-alt-hardening.patch
Patch3: cups-1.4.0-rh-lpr-help.patch
Patch4: cups-1.4.3-rh-no-export-ssllibs.patch
Patch5: cups-1.4.3-rh-driverd-timeout.patch
Patch6: cups-1.6.2-fc-lspp.patch
Patch7: cups-1.4.6-alt-config-libs.patch
Patch9: cups-1.6.1-rh-0755.patch
Patch10: cups-1.6-rh-dnssd-deviceid.patch
Patch15: cups-1.6.1-rh-systemd-socket.patch
Patch16: cups-1.5.3-translation.patch
Patch19: cups-1.6.1-ubuntu-work-around-some-broken-ipp-printers.patch
Patch22: cups-1.6.1-ubuntu-airprint-support.patch
Patch26: cups-1.6.1-ubuntu-cupsd-no-crash-on-avahi-threaded-poll-shutdown.patch
Patch29: cups-1.4-ubuntu-default-error-policy-retry-job.patch
Patch31: cups-1.6.1-alt-faq-localization.patch
Patch32: cups-1.6.2-alt-makefile.patch
Requires: printer-testpages bc cups-filters

PreReq: lib%name = %version-%release, ghostscript-cups
#PreReq: urw-fonts >= 1.0.7pre41-alt3
PreReq: alternatives >= 0.2

Provides: %name-ppd = %version %name-common = %version
Obsoletes: %name-ppd < %version %name-common < %version
Provides: cups-libs = %version

#use external pdftops filter
BuildPreReq: /usr/bin/pdftops
Requires: /usr/bin/pdftops

# for DBUSDIR
BuildRequires: dbus

# Automatically added by buildreq on Wed Mar 23 2011 (-bi)
BuildRequires: ImageMagick-tools gcc-c++ libacl-devel libdbus-devel libgcrypt-devel libjpeg-devel libldap-devel libopenslp-devel libpam-devel libpng-devel libssl-devel libtiff-devel libusb-devel poppler xdg-utils libselinux-devel libaudit-devel fontconfig-devel libsystemd-daemon-devel libavahi-devel

%description
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. It has been developed by Easy Software Products
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.

This is the main package needed for CUPS servers (machines where a
printer is connected to or which host a queue for a network
printer). It can also be used on CUPS clients so that they simply pick
up broadcasted printer information from other CUPS servers and do not
need to be assigned to a specific CUPS server by an
/etc/cups/client.conf file.

%package ppd
Summary: ppd drivers for %name
License: GPL
Group: System/Servers
PreReq: %name = %version-%release

%description ppd
ppd drivers for %name


%package backend-pdf
Summary: pdf backend for %name
License: GPL
Group: System/Servers
PreReq: %name = %version-%release

%description backend-pdf
pdf backend for %name, allows to create pdf files "on-fly"

%package -n lib%name
Summary: Common Unix Printing System - CUPS library
License: LGPL
Group: System/Servers

%description -n lib%name
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This package contains the CUPS API library
which contains common functions used by both the CUPS daemon and all
CUPS frontends (lpr-cups, xpp, qtcups, kups, ...).

This package you need for both CUPS clients and servers. It is also
needed by Samba.

%package -n lib%name-devel
Summary: Common Unix Printing System - Development environment "libcups"
License: LGPL
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version %name-ddk = %version
Obsoletes: %name-devel < %version %name-ddk < %version

%description -n lib%name-devel
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This is the development package for
creating additional printer drivers, printing software, and other CUPS
services using the main CUPS library "libcups".

%package -n alterator-backend-%name
Summary: Alterator backend for the Common Unix Printing System
License: GPL
Group: System/Servers
Requires: %name = %version-%release
Requires: alterator > 1.99-alt14

%description -n alterator-backend-%name
Alterator backend for the Common Unix Printing System

%package ipptool
Summary: Common Unix Printing System - tool for performing IPP requests
Group: System/Servers
License: GPL
Requires: lib%name = %version-%release

%description ipptool
Sends IPP requests to the specified URI and tests and/or displays the results.


%prep
%setup
%setup -T -D

tar xf %SOURCE114

%patch1 -p1
%patch2 -p2
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p2
%patch9 -p1
%patch10 -p1
%patch15 -p1
%patch16 -p1
%patch19 -p1
%patch22 -p1
%patch26 -p1
%patch29 -p1
%patch32 -p1
%patch31 -p1

%build
aclocal -I config-scripts
autoconf -I config-scripts

%configure \
   --enable-pie \
   --enable-relro \
   --enable-dbus \
   --enable-libusb \
   --with-cups-user=lp \
   --with-cups-group=lp \
   --with-log-file-perm=0600 \
   --with-docdir=%_docdir/%name-%version \
    --localstatedir=%_var \
    --enable-lspp \
    --enable-avahi \
    --with-local_protocols='dnssd'
#   --with-local_protocols='CUPS dnssd'  \
#    --with-remote_protocols='CUPS dnssd'
    #

%make_build STRIPPROG=touch

%install
make BUILDROOT=%buildroot STRIPPROG=touch install

install -Dpm 755 %SOURCE100 %buildroot%_sysconfdir/control.d/facilities/%name
install -Dpm 644 %SOURCE101 %buildroot%_sysconfdir/pam.d/%name
install -Dpm 644 %SOURCE102 %buildroot%_altdir/%name
install -Dpm 755 %SOURCE103 %buildroot%_initdir/%name
install -Dpm 644 %SOURCE104 %buildroot%_sysconfdir/xinetd.d/%name-lpd
install -Dpm 644 %SOURCE105 %buildroot%_sysconfdir/modprobe.d/blacklist-%name

# Install systemd files
install -Dpm 644 %SOURCE110 %buildroot%systemd_unitdir/%name.path
install -Dpm 644 %SOURCE111 %buildroot%systemd_unitdir/%name.service
install -Dpm 644 %SOURCE112 %buildroot%systemd_unitdir/%name.socket
install -Dpm 644 %SOURCE113 %buildroot%_sysconfdir/tmpfiles.d/%name.conf


# prepare the commands conflicting with LPD for the update-alternatives treatment
for i in lpr lpq lprm lp cancel lpstat
do
    mv %buildroot%_bindir/$i %buildroot%_bindir/$i-%name
    mv %buildroot%_man1dir/$i.1.gz %buildroot%_man1dir/$i-%name.1.gz
done
mv %buildroot%_sbindir/lpc %buildroot%_sbindir/lpc-%name
mv %buildroot%_man8dir/lpc.8.gz %buildroot%_man8dir/lpc-%name.8.gz
mv %buildroot%_sysconfdir/modprobe.d/blacklist-cups %buildroot%_sysconfdir/modprobe.d/blacklist-cups.conf

#link default fonts to URW
#rm -rf %buildroot%_datadir/%name/fonts/Monospace*
#ln -sf %_datadir/fonts/type1/urw/n022003l.pfb %buildroot%_datadir/%name/fonts/Monospace
#ln -sf %_datadir/fonts/type1/urw/n022004l.pfb %buildroot%_datadir/%name/fonts/Monospace-Bold
#ln -sf %_datadir/fonts/type1/urw/n022023l.pfb %buildroot%_datadir/%name/fonts/Monospace-Oblique
#ln -sf %_datadir/fonts/type1/urw/n022024l.pfb %buildroot%_datadir/%name/fonts/Monospace-BoldOblique

#create some empty config files to prevent .rpmsave on update from cups-1.1.x
touch %buildroot/%_sysconfdir/%name/printers.conf

#fix icons
convert -resize 48x48 desktop/cups-64.png  desktop/cups-48.png
install -Dpm 644 desktop/cups-48.png %buildroot%_liconsdir/cups.png

# install /lib/tmpfiles.d/cups.conf
mkdir -p %buildroot/lib/tmpfiles.d
cat > %buildroot/lib/tmpfiles.d/cups.conf <<EOF
d %_runtimedir/cups 0755 root lp -
d %_runtimedir/cups/certs 0511 lp sys -
EOF

# /lib/tmpfiles.d/cups-lp.conf
cat > %buildroot/lib/tmpfiles.d/cups-lp.conf <<EOF
# This file is part of cups.
#
# Legacy parallel port character device nodes, to trigger the
# auto-loading of the kernel module on access.
#
# See tmpfiles.d(5) for details

c /dev/lp0 0660 root lp - 6:0
c /dev/lp1 0660 root lp - 6:1
c /dev/lp2 0660 root lp - 6:2
c /dev/lp3 0660 root lp - 6:3
EOF

mkdir -p %buildroot/lib/udev/devices
touch %buildroot/lib/udev/devices/lp0
touch %buildroot/lib/udev/devices/lp1
touch %buildroot/lib/udev/devices/lp2
touch %buildroot/lib/udev/devices/lp3

%pre
%pre_control %name

%post
%post_control %name -s server
%post_service %name
rm -f /var/cache/cups/ppds.dat

%preun
%preun_service %name

%triggerpostun -- %name < 1.5.0-alt4
[ -f %_sysconfdir/modprobe.d/blacklist-cups.rpmsave ] && {
    echo "Renaming %_sysconfdir/modprobe.d/blacklist-cups, please check"
    mv -vf %_sysconfdir/modprobe.d/blacklist-cups.conf %_sysconfdir/modprobe.d/blacklist-cups.rpmnew
    mv -vf %_sysconfdir/modprobe.d/blacklist-cups.rpmsave %_sysconfdir/modprobe.d/blacklist-cups.conf
    } ||:

%files
%doc %_docdir/%name-%version

%config(noreplace) %_sysconfdir/%name
%config(noreplace) %_sysconfdir/modprobe.d/*
#special hack for snmp.conf
%config(noreplace) %attr(0640,root,lp) %_sysconfdir/%name/snmp.conf
%config(noreplace) %_sysconfdir/xinetd.d/%name-lpd
%config(noreplace) %_sysconfdir/pam.d/%name
%systemd_unitdir/%name.*
%config(noreplace) %_sysconfdir/tmpfiles.d/%name.conf
%_sysconfdir/control.d/facilities/%name
%_initdir/%name
%_altdir/%name
%_sysconfdir/dbus-1/system.d/%name.conf

%_prefix/lib/%name

%_datadir/%name
%exclude %_datadir/%name/examples
%exclude %_datadir/%name/ipptool
%exclude %_datadir/%name/data/testprint
%exclude %_datadir/%name/banners/*

%_logdir/%name
%dir %_spooldir/%name
%dir %_spooldir/%name/tmp
%dir %_cachedir/%name
%attr(0755,root,lp) %ghost %dir %_var/run/%name/

%_iconsdir/hicolor/*/apps/*.png
%_desktopdir/%name.desktop

%_bindir/cupstestdsc
%_bindir/cupstestppd
%attr(02711,root,lp) %_bindir/cancel-cups
%attr(02711,root,lp) %_bindir/lp-cups
%attr(02711,root,lp) %_bindir/lpoptions
%attr(02711,root,lp) %_bindir/lppasswd
%attr(02711,root,lp) %_bindir/lpq-cups
%attr(02711,root,lp) %_bindir/lpr-cups
%attr(02711,root,lp) %_bindir/lprm-cups
%attr(02711,root,lp) %_bindir/lpstat-cups

%_sbindir/*

%_man1dir/*
%exclude %_man1dir/ppd*
%exclude %_man1dir/ipptool*

%_man7dir/*

%_man5dir/*
%exclude %_man5dir/ppd*

%_man8dir/*

%_datadir/%name/model
%_datadir/locale/*/*.po

%attr(0660, root, lp) %dev(c, 6, 0) /lib/udev/devices/lp0
%attr(0660, root, lp) %dev(c, 6, 1) /lib/udev/devices/lp1
%attr(0660, root, lp) %dev(c, 6, 2) /lib/udev/devices/lp2
%attr(0660, root, lp) %dev(c, 6, 3) /lib/udev/devices/lp3

/lib/tmpfiles.d/cups.conf
/lib/tmpfiles.d/cups-lp.conf

#%_sysconfdir/fonts/conf.d/99pdftoopvp.conf

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_bindir/ppd*
%_includedir/%name
%_datadir/%name/examples
%_libdir/*.so
%_man1dir/ppd*
%_man5dir/ppd*


%files ipptool
%_bindir/ipptool
%dir %_datadir/cups/ipptool
%_datadir/cups/ipptool/create-printer-subscription.test
%_datadir/cups/ipptool/get-completed-jobs.test
%_datadir/cups/ipptool/get-jobs.test
%_datadir/cups/ipptool/ipp-1.1.test
%_datadir/cups/ipptool/ipp-2.0.test
%_datadir/cups/ipptool/ipp-2.1.test
%_datadir/cups/ipptool/testfile.jpg
%_datadir/cups/ipptool/testfile.pdf
%_datadir/cups/ipptool/testfile.ps
%_datadir/cups/ipptool/testfile.txt
%_man1dir/ipptool.1.gz

%changelog
