Name: curl
Version: 7.31.0
Release: alt2.M70P.1

Summary: Gets a file from a FTP, GOPHER or HTTP server
Summary(ru_RU.UTF-8): Утилиты и библиотеки для передачи файлов
License: MPL or MIT
Group: Networking/File transfer
Url: http://curl.haxx.se

Source: %url/download/%name-%version.tar
Patch0: curl-%version-%release.patch

Requires: lib%name = %version-%release

# Automatically added by buildreq on Tue Mar 15 2011
BuildRequires: glibc-devel-static groff-base libidn-devel libssh2-devel libssl-devel zlib-devel python-modules

%package -n lib%name
Summary: The shared library for file transfer
Summary(ru_RU.UTF-8): Библиотеки для передачи файлов
Group: System/Libraries
Provides: %name-lib = %version
Obsoletes: %name-lib < %version
Requires: ca-certificates

%package -n lib%name-devel
Summary: Header files for lib%name
Summary(ru_RU.UTF-8): Заголовочные файлы для lib%name
Group: Development/C
Requires: lib%name = %version-%release bc
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%package -n lib%name-devel-static
Summary: Static libraries for lib%name
Summary(ru_RU.UTF-8): Статические библиотеки для lib%name
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
Curl is a client to get documents/files from servers, using any of the
supported protocols. The command is designed to work without user
interaction or any kind of interactivity.

Curl offers a busload of useful tricks like proxy support, user
authentication, ftp upload, HTTP post, file transfer resume and more.

NOTE: This version is compiled with SSL (https) support.

%description -l ru_RU.UTF-8
Curl - это клиент для получения файлов или документов с серверов,
используя один из поддерживаемых протоколов.  Утилита спроектирована
для работы в неинтерактивном режиме.

Curl позволяет выполнять различные операции над сетевыми файлами,
реализуя поддержку прокси, авторизацию пользователя, докачку файлов и
многое другое.

%description -n lib%name
This package contains lib%name shared library of functions for
sending and receiving files through various protocols, including
http and ftp.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет содержит разделяемую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

%description -n lib%name-devel
This package contains lib%name development library of functions for
sending and receiving files through various protocols, including
http and ftp.

This package is required for development of applications that
utilize lib%name.

%description -n lib%name-devel -l ru_RU.UTF-8
Этот пакет содержит девелоперскую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

Этот пакет необходим для разработки приложений, использующих lib%name.

%description -n lib%name-devel-static
This package contains lib%name static library of functions for
sending and receiving files through various protocols, including
http and ftp.

This package is required for development of statically linked
applications that utilize lib%name.

%description -n lib%name-devel-static -l ru_RU.UTF-8
Этот пакет содержит статическую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

Этот пакет необходим для разработки статически слинкованных приложений,
использующих lib%name.

%prep
%setup -q
%patch0 -p1

%build
./buildconf
%configure \
	--with-ssl \
	--with-libidn \
	--enable-ipv6 \
	--disable-rpat \
	--disable-ldap \
	--enable-threaded-resolver \
	--without-gssapi \
	--with-ca-bundle=%_datadir/ca-certificates/ca-bundle.crt

%make_build

%install
%makeinstall_std

%check
%make_build -k test

%files
%_bindir/curl
%_man1dir/curl.1*

%files -n lib%name
%_libdir/*.so.*

%doc CHANGES README* docs/{FAQ,FEATURES}

%files -n lib%name-devel
%_libdir/*.so
%_libdir/pkgconfig/libcurl.pc
%_bindir/curl-config
%_includedir/*
%_man3dir/*
%_man1dir/curl-config.1*
%doc docs/{THANKS,BUGS,CONTRIBUTE,INTERNALS,MANUAL,RESOURCES,TheArtOfHttpScripting,TODO,examples}

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
