%define _cyrususer cyrus
%define _cyrusgroup cyrus
%define _vardata %_var/lib/imap
%define _spooldata %_var/spool/imap
%define _cyrexecdir %_libexecdir/cyrus
%define _confdir master/conf
%define _contribdir %_datadir/%name/contrib
%define _cyrusconf %_confdir/prefork.conf

Name: cyrus-imapd
Version: 2.4.18
Release: alt1.M70P.1

Summary: A high-performance mail store with IMAP and POP3 support
License: CMU License
Group: System/Servers

# old import was made by:
# $ git-cvsimport -v -r git-cvs -i -k -d :pserver:anoncvs@cvs.andrew.cmu.edu:/cvs cyrus
# fresh sources available via git at https://git.cyrus.foundation/diffusion/I/cyrus-imapd
Url: http://www.cyrusimap.org/

Source0: %name-%version.tar
Source1: cyrus-procmailrc
Source2: cyrus-user-procmailrc.template
Source3: %name.logrotate
Source4: %name.imapd-conf
Source5: README.ALT
Source6: %name.control
Source7: %name.pam-config
Source8: %name-procmail+cyrus.mc
Source10: %name.sysconfig
Source11: %name.cvt_cyrusdb_all
Source12: %name.magic
Source13: %name.sasl-conf
Source14: %name.cron-daily
Source16: folderxfer
Source17: imapcreate.pl
Source18: inboxfer
Source19: %name-README.HOWTO-recover-mailboxes.db
Source20: %name-sendmail-8.12.9-cyrusv2.m4
Source21: %name.init

#Patch7: http://servercc.oakton.edu/~jwade/cyrus/cyrus-imapd-2.1.3/cyrus-imapd-2.1.3-flock.patch

PreReq: e2fsprogs /sbin/chkconfig /sbin/service cert-sh-functions
Requires: su
Provides: MDA imap IMAPD POP3D

BuildRequires: control flex gcc-c++ groff-extra groff-ps libdb4-devel libldap-devel libsasl2-devel
BuildRequires: libssl-devel perl-Pod-Parser perl-Term-ReadLine-Gnu perl-devel transfig zlib-devel
BuildRequires: libwrap-devel libnet-snmp-devel libnl-devel libsensors3-devel

%description
The %name package contains the core of the Cyrus IMAP server.
It is a scaleable enterprise mail system designed for use from
small to large enterprise environments using standards-based
internet mail technologies.

A full Cyrus IMAP implementation allows a seamless mail and bulletin
board environment to be set up across multiple servers. It differs from
other IMAP server implementations in that it is run on "sealed"
servers, where users are not normally permitted to log in. The mailbox
database is stored in parts of the filesystem that are private to the
Cyrus IMAP server. All user access to mail is through software using
the IMAP, POP3, or KPOP protocols. TLS supported for security.

%package murder
Group: System/Servers
Summary: Cyrus IMAP server murder aggregator system files
Requires: %name = %version-%release

%description murder
The %name-murder package contains the Cyrus murder aggregator system,
i.e. IMAP, POP3 and LMTP proxies, and the mupdate mailbox master daemon.
It allows for cluster setups where there are many backend Cyrus spools
and frontend proxy servers.

%package ldap
Group: System/Servers
Summary: Cyrus IMAP server ldap auth system
Requires: %name = %version-%release

%description ldap
The %name-ldap package contains the Cyrus ldap auth system.

%package devel
Group: Development/C
Summary: Cyrus IMAP server development files

%description devel
The %name-devel package contains header files and libraries
necessary for developing applications which use the imclient library.

%package -n perl-Cyrus
Group: Development/Perl
Summary: Cyrus IMAP server utility Perl modules
Provides: perl(Cyrus/IMAP.pm) perl(Cyrus/IMAP/Admin.pm)

%description -n perl-Cyrus
The perl-Cyrus package contains Perl modules necessary to use the
Cyrus IMAP server administration utilities.

%package utils
Group: System/Servers
Summary: Cyrus IMAP server administration utilities
Requires: perl-Cyrus = %version-%release perl(Term/ReadLine.pm)

%description utils
The %name-utils package contains administrative tools for the
Cyrus IMAP server. It can be installed on systems other than the
one running the server.

%package doc
Group: System/Servers
Summary: Cyrus IMAP server documentation
BuildArch: noarch

%description doc
The %name-doc package contains Here the documentation about
Cyrus IMAP server.

%prep
%setup

%build
# kerberos include is needed (because of openssl-0.9.7 ?)
CPPFLAGS="`krb5-config --cflags` $CPPFLAGS"
export CPPFLAGS
CFLAGS="$RPM_OPT_FLAGS -fPIC $CFLAGS"
export CFLAGS
LDFLAGS="`krb5-config --libs` $LDFLAGS"
export LDFLAGS

pushd makedepend
./configure
make
popd

aclocal -I cmulocal
autoheader
autoconf

# this is hack
#echo '#define CYRUS_CVSDATE 20071211' > imap/xversion.h

%configure \
  --enable-netscapehack \
  --enable-nntp \
  --enable-murder \
  --with-snmp \
  --with-perl=perl \
  --with-ldap \
  --with-libwrap=%prefix \
  --with-cyrus-prefix=%_cyrexecdir \
  --with-service-path=%_cyrexecdir \
  --with-cyrus-user=%_cyrususer \
  --with-cyrus-group=%_cyrusgroup \
  --enable-idled \
  --with-bdb-incdir=%_includedir/db4 \
  --enable-replication

#  --with-krb=%prefix/lib/krb5

make

# produce doc/man
make -C doc -f Makefile.dist dist

# Modify docs master --> cyrus-master
pushd man
  sed -i 's/master(8)/cyrus-master(8)/' *5 *8
popd
pushd doc
  sed -i 's/master/cyrus-master/g' man.html
popd
pushd doc/man
  sed -i 's/master(8)/cyrus-master(8)/' *html
popd

# Modify path in perl scripts
find . -type f -name \*.pl -print0 |
    xargs -r0 perl -pi -e 's@\/usr\/local\/bin\/perl@perl@' --

# Cleanup of doc dir
find doc perl -name CVS -type d | xargs -r rm -fr --
find doc -name "*~" -type f | xargs -r rm -f --
rm -f doc/Makefile.dist
rm -f doc/text/htmlstrip.c

%install
# Do what the regular make install does
make install DESTDIR=%buildroot PREFIX=%prefix mandir=%_mandir \
	INSTALLDIRS=vendor
make -C man install DESTDIR=%buildroot PREFIX=%prefix mandir=%_mandir

install -m 755 imtest/imtest		%buildroot%_cyrexecdir/
install -m 755 perl/imap/cyradm	%buildroot%_cyrexecdir/

# Install tools
for tool in tools/* ; do
  test -f ${tool} && install -m 755 ${tool} %buildroot%_cyrexecdir/
done

install -d \
  %buildroot%_sysconfdir/{rc.d/init.d,logrotate.d,pam.d,sysconfig,cron.daily} \
  %buildroot%_libdir/sasl2 \
  %buildroot%_bindir \
  %buildroot%_spooldata/stage. \
  %buildroot%_vardata/{user,quota,proc,log,msg,socket,db,sieve,rpm,backup} \
  %buildroot%_contribdir \
  %buildroot%_datadir/%name/rpm

install -m 755 %SOURCE11   %buildroot%_cyrexecdir/cvt_cyrusdb_all
install -m 755 %SOURCE12   %buildroot%_datadir/%name/rpm/magic

install -m 644 %_cyrusconf %buildroot%_sysconfdir/cyrus.conf
install -m 644 %SOURCE4    %buildroot%_sysconfdir/imapd.conf
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/pop
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/imap
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/sieve
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/mupdate
install -m 644 %SOURCE7    %buildroot%_sysconfdir/pam.d/lmtp
install -m 644 %SOURCE10   %buildroot%_sysconfdir/sysconfig/%name

install -m 755 %SOURCE21    %buildroot%_initdir/%name
install -m 644 %SOURCE3    %buildroot%_sysconfdir/logrotate.d/%name
install -m 755 %SOURCE14   %buildroot%_sysconfdir/cron.daily/%name
install -pDm600 %SOURCE13 %buildroot%_sysconfdir/sasl2/Cyrus.conf

install -m 755 -d doc/conf
install -m 644 %_confdir/*.conf doc/conf/
install -pD -m 755 %SOURCE6 %buildroot%_controldir/%name

install -m 755 %SOURCE16 %SOURCE17 %SOURCE18  %buildroot%_contribdir
install -m 644 %SOURCE19 %SOURCE20 %SOURCE5 doc/

# Rename 'master' binary and manpage to avoid crash with postfix
mv -f %buildroot%_cyrexecdir/master	%buildroot%_cyrexecdir/cyrus-master
mv -f %buildroot%_mandir/man8/master.8 %buildroot%_mandir/man8/cyrus-master.8
mv -f doc/man/master.8.html doc/man/cyrus-master.8.html

# Move utilites from /usr/libexec/cyrus to /usr/bin
for i in arbitronsort.pl cyradm imtest mupdate-loadgen.pl convert-sieve.pl \
	 mknewsgroups config2header config2man masssievec
do
    mv %buildroot%_cyrexecdir/$i %buildroot/%_bindir/
done

# Create filelist for perl package, compress manpages before
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress
find %buildroot%perl_vendor_autolib/Cyrus %buildroot%perl_vendor_archlib/Cyrus -type f -print |
  sed "s@^%buildroot@@g" |
  grep -v perllocal.pod |
  grep -v "\.bs" |
  grep -v "\.packlist" > perl-Cyrus-%version-filelist
if [ "$(cat perl-Cyrus-%version-filelist)X" = "X" ] ; then
  echo "ERROR: EMPTY FILE LIST"
  exit -1
fi

# Remove installed but not packaged files
rm -f %buildroot%_cyrexecdir/not-mkdep
find %buildroot -name "perllocal.pod" -exec rm -f {} \;
find %buildroot -name ".packlist" -exec rm -f {} \;

# Create file wich contains information about compiled db backends
for conf in DUPLICATE MBOX SEEN SUBS TLS
do
  echo CONFIG_DB_${conf}=$(grep "CONFIG_DB_${conf}" config.h | sed -e 's/)//' -e 's/_/-/g' | cut -d" " -f3 | cut -d"-" -f2) >> %buildroot%_datadir/%name/rpm/db.cfg
done

# directory for ssl-certs
install -dm750 %buildroot%_vardata/ssl

# imap sessions logs
mkdir -p %buildroot%_vardata/log/cyrus

# needed for %ghost
touch %buildroot%_vardata/ssl/cyrus.cert
touch %buildroot%_vardata/ssl/cyrus.key

%add_findreq_skiplist /usr/bin/cyradm

%pre
/usr/sbin/groupadd -r -f %_cyrusgroup ||:
/usr/sbin/useradd -g %_cyrusgroup -G sasl -c "Cyrus IMAP Server" -d %_vardata \
  -s /dev/null -r %_cyrususer 2> /dev/null ||:

%post
%post_service %name
# Force synchronous updates, usually only on ext2 filesystems
for i in %_vardata/{user,quota} %_spooldata
do
	fstype=`find $i -maxdepth 0 -printf %%F`
	[ x"$fstype" = x"ext2" ] && chattr -R +S $i 2>/dev/null ||:
done

%preun
%preun_service %name

%files
# initscript
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name

# other stuff
%config %_controldir/*
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/cron.daily/%name

# cyrus configs
%config(noreplace) %_sysconfdir/cyrus.conf
%config(noreplace) %_sysconfdir/imapd.conf
%config(noreplace) %_sysconfdir/pam.d/imap
%config(noreplace) %_sysconfdir/pam.d/lmtp
%config(noreplace) %_sysconfdir/pam.d/pop
%config(noreplace) %_sysconfdir/pam.d/sieve
%config(noreplace) %attr(640,root,%_cyrusgroup) %_sysconfdir/sasl2/Cyrus.conf

# suid deliver
%attr(4710,%_cyrususer,%_cyrusgroup) %_cyrexecdir/deliver

# data dirs
%dir %attr(1770,root,%_cyrusgroup) %_vardata
%dir %attr(1770,root,%_cyrusgroup) %_vardata/*
%dir %attr(1770,root,%_cyrusgroup) %_vardata/log/*
%dir %attr(1770,root,%_cyrusgroup) %_spooldata
%dir %attr(1770,root,%_cyrusgroup) %_spooldata/*

%_datadir/%name
%_man5dir/*
%_man8dir/*

# ssl-related
%dir %attr(0750,root,%_cyrusgroup) %_vardata/ssl
%ghost %attr(0640,root,%_cyrusgroup) %verify(not md5 mtime size) %_vardata/ssl/cyrus.cert
%ghost %attr(0640,root,%_cyrusgroup) %verify(not md5 mtime size) %_vardata/ssl/cyrus.key

%_cyrexecdir
%exclude %_cyrexecdir/lmtpproxyd
%exclude %_cyrexecdir/mupdate
%exclude %_cyrexecdir/pop3proxyd
%exclude %_cyrexecdir/proxyd
%exclude %_cyrexecdir/ptdump
%exclude %_cyrexecdir/ptexpire
%exclude %_cyrexecdir/ptloader
%exclude %_contribdir

%files doc
%doc COPYRIGHT README README.autocreate
%doc $RPM_SOURCE_DIR/cyrus-procmailrc
%doc $RPM_SOURCE_DIR/cyrus-user-procmailrc.template
%doc $RPM_SOURCE_DIR/%name-procmail+cyrus.mc
%doc doc/*

%files murder
%config(noreplace) %_sysconfdir/pam.d/mupdate
%_cyrexecdir/lmtpproxyd
%_cyrexecdir/mupdate
%_cyrexecdir/pop3proxyd
%_cyrexecdir/proxyd

%files ldap
%_cyrexecdir/ptdump
%_cyrexecdir/ptexpire
%_cyrexecdir/ptloader

%files devel
%_includedir/cyrus
%_libdir/lib*.a
%_man3dir/*

%files -n perl-Cyrus
%perl_vendor_autolib/Cyrus*
%perl_vendor_archlib/Cyrus*
%doc perl/imap/README
%doc perl/imap/Changes
%doc perl/imap/examples

%files utils
%_contribdir
%_bindir/*
%_man1dir/*
%dir %_datadir/%name

%changelog
