%define ver_major 1.6

Name: darktable
Version: %ver_major.9
Release: alt0.M70P.1

Summary: Darktable is a virtual lighttable and darkroom for photographer
License: GPLv3
Group: Graphics

Url: http://%name.org/
#VCS: https://github.com/darktable-org/darktable.git
#Source: %name-%version.tar
Source: https://github.com/darktable-org/darktable/releases/download/release-%version/%name-%version.tar.xz

BuildRequires: gcc-c++ libgomp-devel

BuildPreReq:  rpm-build-gnome
BuildRequires: /proc
BuildRequires: libgio-devel >= 2.30 libgtk+2-devel >= 2.24
BuildRequires: cmake intltool libSDL-devel libXScrnSaver-devel libXcomposite-devel libXcursor-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXinerama-devel libXpm-devel libXrandr-devel
BuildRequires: libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel
BuildRequires: libdbus-glib-devel libexiv2-devel libflickcurl-devel libsecret-devel
BuildRequires: libgphoto2-devel libjpeg-devel liblcms2-devel liblensfun-devel
BuildRequires: libpng-devel librsvg-devel libsqlite3-devel libtiff-devel libxkbfile-devel lsb-release
BuildRequires: openexr-devel perl-Pod-Parser
BuildRequires: libjson-glib-devel libsoup-devel xsltproc libpixman-devel libexpat-devel
BuildRequires: libcolord-gtk-devel libudev-devel
BuildRequires: libGraphicsMagick-c++-devel libopenjpeg-devel
BuildRequires: libharfbuzz-devel libwebp-devel libxshmfence-devel
# for build from git tree
#BuildRequires: gnome-doc-utils fop saxon ...

%description
darktable is a virtual light table and darkroom for photographers. It manages
your digital negatives in a database and lets you view them through a zoomable
light table. It also enables you to develop raw images and enhance them.

%prep
%setup

%build
%cmake -DCMAKE_SKIP_RPATH:BOOL=OFF \
-DCMAKE_BUILD_TYPE=Release \
-DBINARY_PACKAGE_BUILD:BOOL=ON
%cmake_build VERBOSE=1

%install
%cmakeinstall_std

ln -s %name/lib%name.so %buildroot%_libdir/lib%name.so

install -pD -m644 data/pixmaps/16x16/darktable.png %buildroot%_miconsdir/darktable.png
install -pD -m644 data/pixmaps/32x32/darktable.png %buildroot%_niconsdir/darktable.png
install -pD -m644 data/pixmaps/48x48/darktable.png %buildroot%_liconsdir/darktable.png

%find_lang %name

%files -f %name.lang
%_bindir/*
%_datadir/%name/
%_libdir/lib%name.so
%_libdir/%name/
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_datadir/appdata/%name.appdata.xml
%exclude /usr/share/doc/%name/

%changelog
