Name: davfs2
Version: 1.4.6
Release: alt2

Summary: Linux file system driver that allows you to mount a WebDAV server as a local file system.
License: GPLv3+
Group: Networking/Other
Url: http://savannah.nongnu.org/projects/%name/

Packager: Sergey Kurakin <kurakin@altlinux.org>

Source: %name-%version.tar

# Automatically added by buildreq on Mon May 25 2009
BuildRequires: libexpat-devel libneon-devel libssl-devel zlib-devel libkeyutils-devel

%description
WebDAV is an extension to HTTP that allows remote collaborative
authoring of Web resources, defined in RFC 4918.

davfs2 is a Linux file system driver that allows you to mount a WebDAV
server as a local file system, like a disk drive. This way applications
can access resources on a Web server without knowing anything about HTTP
or WebDAV.

davfs2 runs as a daemon in userspace. It uses the kernel file system
fuse. To connect to the WebDAV server it makes use of the neon library.
Neon supports TLS/SSL (using OpenSSL or GnuTLS) and access
via proxy server.

%prep
%setup -n %name-%version

%build
%autoreconf
%configure
%make_build

%install
%make_install install DESTDIR=%buildroot
ln -sf %_sbindir/mount.davfs %buildroot/sbin/mount.davfs
ln -sf %_sbindir/umount.davfs %buildroot/sbin/umount.davfs
%find_lang %name

%pre
# Add davfs2 group
%_sbindir/groupadd -r -f davfs2 2>/dev/null || :

%files -f %name.lang
%doc AUTHORS ChangeLog FAQ INSTALL NEWS README TODO THANKS
%config %_sysconfdir/%name/
/sbin/mount.davfs
/sbin/umount.davfs
%_sbindir/*
%_man5dir/*
%_man8dir/*
%_datadir/%name/
%exclude %_defaultdocdir/%name
%exclude %_mandir/de
%exclude %_mandir/es

%changelog
