Name: dblatex
Version: 0.3
Release: alt1.1.1

Summary: DocBook to LaTeX/ConTeXt Publishing
License: %gpl2plus
Group: Text tools

Url: http://dblatex.sourceforge.net/
Source: %name-%version.tar
Packager: Kirill Maslinsky <kirill@altlinux.org>

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-python rpm-build-texmf
# Automatically added by buildreq on Thu Jun 26 2008
BuildRequires: python-devel python-modules-encodings python-modules-logging texlive-latex-extra xsltproc
BuildRequires: ImageMagick-tools transfig

BuildArch: noarch

Requires: ImageMagick xsltproc docbook-dtds 
#Requires: ImageMagick tetex-latex-listings tetex-latex-cmap tetex-latex tetex-context xsltproc docbook-dtds tetex-dvips ghostscript-utils fonts-type1-cm-super-tex
#Requires: tetex-latex-unicode >= 20041017-alt1

# this is xelatex's sty, skip to workaround texmf dep tracing unefficiency
%add_texmf_req_skip latex/xecyr

# for backwards compatibility: skip deps not provided by tetex
%add_texmf_req_skip latex/CJKutf8 latex/appendix latex/bibtopic latex/enumitem latex/listings latex/pinyin

%define _dblatex_datadir %_datadir/%name
%define _dblatex_texdir %_texmfmain/tex/latex/%name

%description
Dblatex started as a DB2LaTeX clone, but since then many things have changed
and new features have been added or (hopefully) improved. Now, the portion of
shared code is small if any, and the dblatex purpose is different from DB2LaTeX
on these points:

    * The project is end-user oriented, that is, it tries to hide as much as
    * possible the latex compiling stuff by providing a single clean script to
    * produce directly DVI, PostScript and PDF output.  The actual output
    * rendering is done not only by the XSL stylesheets transformation, but
    * also by a dedicated LaTeX package. The goal is to allow a deep LaTeX
    * customisation without changing the XSL stylesheets.  Post-processing is
    * done by Python, to make publication faster, convert the images if needed,
    * and do the whole compilation.

This project is splitted in two instances working on the same principles. Both
instances are intended to produce DVI, PostScript, PDF documents from DocBook
SGML or XML sources, by converting first to a high level set of TeX macros.

%prep
%setup

%build
%python_build

%install 
%python_install

mkdir -p %buildroot/%_dblatex_texdir
mv %buildroot/%_dblatex_datadir/latex/{contrib,misc/multirow2.sty,style} %buildroot/%_dblatex_texdir
rm -rvf %buildroot/%_dblatex_datadir/latex/misc 

#mkdir -p %buildroot/%_dblatex_datadir
#cp -a buildroot/%_dblatex_datadir/xsl %buildroot/%_dblatex_datadir

mkdir -p %buildroot/%_dblatex_datadir/latex
#cp -a buildroot/%_dblatex_datadir/latex/{graphics,scripts,specs} %buildroot/%_dblatex_datadir/latex
ln -s ../../texmf/tex/latex/dblatex/contrib %buildroot/%_dblatex_datadir/latex/contrib
mv %buildroot/%_dblatex_datadir/latex/graphics %buildroot/%_dblatex_texdir

mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version

%pre
[ -h %_datadir/%name/latex/contrib ] || rm -rf %_datadir/%name/latex/contrib

%files 
%_bindir/dblatex
%_dblatex_datadir
%_dblatex_texdir
%python_sitelibdir/dbtexmf/
%python_sitelibdir/*.egg-info
%_docdir/%name-%version
%_man1dir/dblatex.1.gz

%changelog
