%def_enable snapshot

%define ver_major 0.16
%def_disable introspection
%def_enable gtk_doc

Name: dconf
Version: %ver_major.0
Release: alt2

Summary: A simple configuration system
Group: System/Servers
License: LGPLv2+

Url: https://live.gnome.org/dconf

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: http://download.gnome.org/sources/dconf/%ver_major/%name-%version.tar.xz
%endif
Source1: update-dconf-database.filetrigger

Provides: %_rpmlibdir/update-dconf-database.filetrigger

Requires: lib%name = %version-%release dbus

BuildRequires: libgio-devel >= 2.35.2 libgtk+3-devel >= 3.4 libxml2-devel vala-tools >= 0.17.0
BuildRequires: libdbus-devel gtk-doc intltool xsltproc
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 1.33.3}

%description
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

%package -n lib%name
Summary: Shared library for dconf
Group: System/Libraries

%description -n lib%name
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides shared library required for dconf to work

%package -n lib%name-devel
Summary: Development files for dconf library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This is a dconf development package. Contains files needed for doing
development using dconf.

%package -n lib%name-devel-doc
Summary: Development documentation for dconf library
Group: Development/Documentation
Conflicts: lib%name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package contains development documentation for dconf library.

%package -n dconf-editor
Summary: dconf confuguration editor
Group: Graphical desktop/GNOME
Requires: lib%name = %version-%release

%description -n dconf-editor
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides dconf configuration editor

%package -n lib%name-gir
Summary: GObject introspection data for the dconf library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the dconf library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the dconf library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the dconf library

%package -n lib%name-vala
Summary: Vala language bindings for the dconf library
Group: Development/Other
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-vala
This package provides Vala language bindings  for the dconf library

%define _libexecdir %_prefix/libexec

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
%{?_enable_snapshot:./autogen.sh}
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_sysconfdir/%name/{profile,db}

# rpm posttrans filetrigger
install -pD -m755 {%_sourcedir,%buildroot%_rpmlibdir}/update-dconf-database.filetrigger

%find_lang %name

%files -f %name.lang
%_bindir/dconf
%_libdir/gio/modules/libdconfsettings.so
%_libexecdir/dconf-service
%_datadir/dbus-1/services/ca.desrt.dconf.service
%_rpmlibdir/update-dconf-database.filetrigger
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/profile
%dir %_sysconfdir/%name/db
%_man1dir/%name-service.1.*
%_man1dir/%name.1.*
%_man7dir/%name.7.*
%doc NEWS

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%files -n dconf-editor
%_bindir/dconf-editor
%_datadir/applications/dconf-editor.desktop
%_iconsdir/hicolor/*/apps/*.*
%_iconsdir/HighContrast/*/apps/dconf-editor.png
%_man1dir/dconf-editor.1.*
%config %_datadir/glib-2.0/schemas/ca.desrt.dconf-editor.gschema.xml

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%files -n lib%name-vala
%_datadir/vala/vapi/dconf.deps
%_datadir/vala/vapi/dconf.vapi

%exclude %_datadir/bash-completion/completions/dconf

%changelog
