Name: dcraw
Version: 9.16
Release: alt1

Summary: Command-line decoder for raw digital photos
License: Freely distributable
Group: Graphics

URL: http://www.cybercom.net/~dcoffin/dcraw
Source: %url/archive/dcraw-%version.tar.gz

Source3: %url/dcraw.html
Source4: %url/.badpixels
Source5: %url/ahd_maze.png
Source6: %url/vng_grid.png

# Automatically added by buildreq on Sun Jul 31 2011
BuildRequires: libjasper-devel libjpeg-devel liblcms-devel

# TODO: patch to use lcms2 instead of lcms

%description
dcraw decodes raw photos, displays metadata, and extracts thumbnails.

%prep
%setup -n dcraw

install -m644 %SOURCE3 %SOURCE4 %SOURCE5 %SOURCE6 .

%build
# -O4 shows best speed in benchmarks!
%define _optlevel 4
gcc -I/usr/include/lcms -DLOCALEDIR=\"/usr/share/locale/\" \
	%optflags -o dcraw dcraw.c -ljpeg -lm -llcms -ljasper

%install
install -pD -m755 dcraw %buildroot%_bindir/dcraw
install -pD -m644 dcraw.1 %buildroot%_man1dir/dcraw.1

for lang in ca cs da de eo es fr hu it pl pt ru sv zh_CN zh_TW
do
  mkdir -p -m 755 %buildroot%_mandir/$lang/man1
  cp dcraw_$lang.1 %buildroot%_mandir/$lang/man1/dcraw.1
  mkdir -p -m 755 %buildroot/usr/share/locale/$lang/LC_MESSAGES
  msgfmt -o %buildroot/usr/share/locale/$lang/LC_MESSAGES/dcraw.mo dcraw_$lang.po
done
# No man page exists for Dutch localisation
  mkdir -p -m 755 %buildroot/usr/share/locale/nl/LC_MESSAGES
  msgfmt -o %buildroot/usr/share/locale/nl/LC_MESSAGES/dcraw.mo dcraw_nl.po

%find_lang --with-man dcraw

%files -f dcraw.lang
%_bindir/*
# original man page listed by find_lang
#%_man1dir/*
%doc dcraw.html *.png .badpixels

%changelog
