Name: ddd
Version: 3.3.12
Release: alt1.qa1

Summary: Graphical debugger front-end for GDB, DBX, Ladebug, JDB, Perl, Python
License: GPL
Group: Development/Other
Url: http://www.gnu.org/software/%name/
Packager: Ilya Mashkin <oddity@altlinux.ru>
# ftp://alpha.gnu.org/gnu/%name/
Source: ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source3: http://www.cs.tu-bs.de/softech/ddd/ftp/doc/vse.ps.bz2

Patch1: ddd-3.3.8-alt-texinfo.patch

Requires: gdb
Obsoletes: ddd-static, ddd-semistatic, ddd-dynamic

# Added by buildreq2 on Чтв Окт 05 2006
BuildRequires: flex gcc4.3-c++ libX11-devel libXext-devel libXi-devel libXaw-devel libXp-devel libreadline-devel libtinfo-devel openmotif-devel

%package doc-html
Summary: HTML documentation for %name
Group: Development/Other
Requires: %name = %version-%release

%package doc-ps
Summary: PostScript documentation for %name
Group: Development/Other
Requires: %name = %version-%release

%description
DDD is a graphical front-end for command-line debuggers such as GDB,
DBX, WDB, Ladebug, JDB, XDB, the Perl debugger, or the Python debugger.
Besides "usual" front-end features such as viewing source texts, DDD has
become famous through its interactive graphical data display, where data
structures are displayed as graphs.

%description doc-html
DDD is a graphical front-end for command-line debuggers such as GDB,
DBX, WDB, Ladebug, JDB, XDB, the Perl debugger, or the Python debugger.
Besides "usual" front-end features such as viewing source texts, DDD has
become famous through its interactive graphical data display, where data
structures are displayed as graphs.

This packages contains HTML documentation for DDD.

%description doc-ps
DDD is a graphical front-end for command-line debuggers such as GDB,
DBX, WDB, Ladebug, JDB, XDB, the Perl debugger, or the Python debugger.
Besides "usual" front-end features such as viewing source texts, DDD has
become famous through its interactive graphical data display, where data
structures are displayed as graphs.

This packages contains PostScript documentation for DDD.

%prep
%setup -q
%patch1 -p1

%__install -p -m644 %SOURCE3 doc/
%__rm -f doc/html/%name.html ddd/*.info*
touch ddd/ddd.info.txt
find -type f -name \*.orig -print -delete

%build
%set_automake_version 1.10
#set_autoconf_version 2.5
export CC=gcc-4.3 CXX=g++-4.3


# Without this hack ddd won't build.
#%__install -p -m755 %_datadir/libtool/config.* .

# Fix build via precaching configure variables.
export \
	ac_cv_func_alloca=yes \
	ac_cv_lib_dnet=no \
	ac_cv_lib_dnet_dnet_ntoa=no \
	ac_cv_lib_dnet_stub_dnet_ntoa=no \
	ac_cv_header_elf_h=no \
	ac_cv_header_libelf_h=no \
	ac_cv_header_sys_elf_h=no \
	ac_cv_lib_elf_elf_version=no \
	ice_cv_external_templates=no \
	ice_cv_have_named_return_values=no \
	ac_cv_path_RSH=ssh \
	ac_cv_prog_DEBUGGER=gdb \
	ac_cv_prog_LPR=lpr \
	ac_cv_prog_XTERM=xvt \
	#

# Fix tinfo support.
find -type f -name configure -print0 |
	xargs -r0 %__subst -p 's/mytinfo/tinfo/g' configure*

%add_optflags -DWITH_READLINE
%configure --with-readline

%__rm -rf readline libiberty

# Fix packager information.
cat >ddd/userinfo.C <<__EOF__
#include <stdio.h>
int main (void){ puts ("%packager"); return 0; }
__EOF__

%make_build LIBREADLINE=-lreadline
bzip2 -9fk doc/*.ps

%install
%__mkdir_p $RPM_BUILD_ROOT%_libdir
%makeinstall

%__rm -fv $RPM_BUILD_ROOT%_datadir/%name-%version/[A-Z]*
%__mkdir_p $RPM_BUILD_ROOT%_sysconfdir/X11/app-defaults
%__mv $RPM_BUILD_ROOT%_datadir/%name-%version/%name/Ddd $RPM_BUILD_ROOT%_sysconfdir/X11/app-defaults
rmdir $RPM_BUILD_ROOT%_datadir/%name-%version/%name

%define docdir %_docdir/%name-%version
%__rm -rf $RPM_BUILD_ROOT%docdir
%__mkdir_p $RPM_BUILD_ROOT%docdir
%__cp -a AUTHORS NEWS PROBLEMS TIPS TODO doc/*.ps.* doc/html \
	$RPM_BUILD_ROOT%docdir/


%files
%config %_sysconfdir/X11/app-defaults/*
%_bindir/*
%_datadir/%name-%version
%_mandir/man?/*
%_infodir/*.info*
%dir %docdir
%docdir/[A-Z]*

%files doc-ps
%dir %docdir
%docdir/*.ps.*

%files doc-html
%dir %docdir
%docdir/html

%changelog
