Name: dejagnu
Version: 1.5.1
Release: alt0.3
Epoch: 1

Summary: A front end for testing other programs
License: GPLv3+
Group: Development/Other
Url: http://www.gnu.org/software/%name/
BuildArch: noarch

# git://git.altlinux.org/gears/d/dejagnu.git
Source: %name-%version-%release.tar

Requires: expect /dev/pts
BuildRequires: expect gcc-c++
%{?!_without_check:%{?!_disable_check:BuildRequires: screen /dev/pts}}

%description
DejaGnu is an Expect/Tcl based framework for testing other programs.
DejaGnu has several purposes: to make it easy to write tests for any
program; to allow you to write tests which will be portable to any
host or target where a program must be tested; and to standardize the
output format of all tests (making it easier to integrate the testing
into software development).

%prep
%setup -n %name-%version-%release

%build
%configure
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
find %buildroot%_datadir/%name -type f -name \*.exp -print0 |
	xargs -r0 chmod 644 --
%add_findreq_skiplist %_datadir/%name/libexec/config.guess

%check
[ -w /dev/ptmx ] || exit 0
# Dejagnu test suite also has to test reporting to user.  It needs a
# terminal for that.  That doesn't compute in mock.  Work around it by
# running the test under screen and communicating back to test runner
# via temporary file.  If you have better idea, we accept patches.
t=$(mktemp %name.XXXXXXXX)
SCREENDIR=$HOME/.screen \
screen -D -m sh -c '(make check RUNTESTFLAGS="RUNTEST=$PWD/runtest"; echo $?) >'$t
r=$(tail -n1 $t)
cat $t
rm $t
exit $r

%files
%_bindir/*
%_datadir/%name
%_includedir/*
%_infodir/*
%_mandir/man?/*
%doc NEWS README AUTHORS ChangeLog

%changelog
