Name: deluge
Version: 1.3.6
Release: alt1

Summary: full-featured BitTorrent client
License: GPL
Group: Networking/File transfer

Url: http://deluge-torrent.org
# http://git.deluge-torrent.org/deluge/

Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildArch: noarch

BuildRequires: python-module-dbus-devel python-module-pygtk-devel
BuildRequires: python-module-notify librsvg-devel python-module-pyxdg
BuildRequires: python-module-setuptools python-module-libtorrent-rasterbar
BuildRequires: python-module-simplejson intltool

Requires: deluge-gtk = %version-%release

%description
Deluge is a full-featured  BitTorrent client for Linux, OS X, Unix and
Windows. It uses  libtorrent in it's backend and features multiple
user-interfaces including: GTK+, web and console. It has been designed
using the client server model with a daemon process that handles all the
bittorrent activity. The Deluge daemon is able to run on headless
machines with the user-interfaces being able to connect remotely from
any platform.

Deluge features a rich plugin collection; in fact, most of Deluge's
functionality is available in the form of plugins.

Deluge was created with the intention of being lightweight and
unobtrusive. It is our belief that downloading shouldn't be the primary
task on your computer and therefore shouldn't monopolize system
resources.

Deluge is not designed for any one desktop environment and will work
just fine in GNOME, KDE, XFCE and others. We do our best to adhere to
the  freedesktop standards.

Deluge is  Free Software and is licensed under the  GNU General Public
License.

%package -n python-module-deluge
Group: Networking/File transfer
Summary: full-featured BitTorrent client (common files)
Requires: python-module-simplejson python-module-pyxdg python-module-libtorrent-rasterbar python-module-twisted-web

%description -n python-module-deluge
This package contains data files commons to both the deluge daemon and
the user-interfaces.

%package console
Group: Networking/File transfer
Summary: full-featured BitTorrent client (console UI)
Requires: python-module-deluge = %version-%release

%description console
This package contains the console user-interface.

%package -n deluged
Group: Networking/File transfer
Summary: full-featured BitTorrent client (deluge daemon)
Requires: python-module-deluge = %version-%release

%description -n deluged
Deluge daemon process handles all the bittorrent activity.
The Deluge daemon is able to run on headless machines with the
user-interfaces being able to connect remotely from any platform.

%package gtk
Group: Networking/File transfer
Summary: full-featured BitTorrent client (GTK UI)
Requires: python-module-deluge = %version-%release python-module-twisted-core-gui python-module-pygtk-libglade

%description gtk
This package contains the GTK user-interface.

%package web
Group: Networking/File transfer
Summary: full-featured BitTorrent client (web UI)
Requires: python-module-deluge = %version-%release

%description web
This package contains the web user-interface.

%prep
%setup -q
%patch0 -p1

%build
%python_build

%install
%python_install
rm -f %buildroot%_datadir/pixmaps/*
rm -f %buildroot%python_sitelibdir/%name/ui/webui/scripts/build_webui_tarball.sh
mkdir -p %buildroot{%_initdir,%_sysconfdir/sysconfig,%_spooldir/deluged}
cp altlinux/deluged.init %buildroot%_initdir/deluged
cp altlinux/deluged.sys %buildroot%_sysconfdir/sysconfig/deluged

%pre -n deluged
%_sbindir/groupadd -r -f _deluge
%_sbindir/useradd -r -n -g _deluge -d %_spooldir/deluged -s /dev/null -c "deluge bittorrent daemon" _deluge >/dev/null 2>&1 ||:

%post -n deluged
%post_service deluged

%preun -n deluged
%preun_service deluged

%files
%_bindir/%name
%_man1dir/%name.1*
%doc LICENSE ChangeLog README

%files -n python-module-deluge
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/*.py*
%python_sitelibdir/%name/core
%python_sitelibdir/%name/data
%python_sitelibdir/%name/i18n
%python_sitelibdir/%name/plugins
%dir %python_sitelibdir/%name/ui
%python_sitelibdir/%name/ui/*.py*
%python_sitelibdir/*.egg-info

%files console
%_bindir/%name-console
%_man1dir/%name-console.1*
%python_sitelibdir/%name/ui/console

%files -n deluged
%attr(0755,root,root) %_initdir/deluged
%config(noreplace) %_sysconfdir/sysconfig/deluged
%_bindir/deluged
%_man1dir/deluged.1*
%attr(0775,root,_deluge) %dir %_spooldir/deluged

%files gtk
%_bindir/%name-gtk
%_man1dir/%name-gtk.1*
%python_sitelibdir/%name/ui/gtkui
%_iconsdir/hicolor/*/apps/*
%_iconsdir/scalable/apps/*
%_desktopdir/%name.desktop

%files web
%_bindir/%name-web
%_man1dir/%name-web.1*
%python_sitelibdir/%name/ui/web

%changelog
