%define emacs_mode desktop-entry
%define _emacs_startscriptsdir %_sysconfdir/emacs/site-start.d

Name: desktop-file-utils
Version: 0.22.0.patchset1
Release: alt1

Summary: Utilities for manipulating .desktop files
Group: Graphical desktop/Other
License: GPL
URL: http://www.freedesktop.org/software/desktop-file-utils

Source: %name-%version.tar

BuildRequires: gcc glibc-devel emacs-cedet emacs-common emacs-leim glib2-devel libpopt-devel pkg-config automake

%description
.desktop files are used to describe an application for inclusion in
GNOME or KDE menus.  This package contains desktop-file-validate which
checks whether a .desktop file complies with the specification at
http://www.freedesktop.org/standards/, and desktop-file-install 
which installs a desktop file to the standard directory, optionally 
fixing it up in the process.

%package -n emacs-mode-%emacs_mode
Summary: Emacs major mode for editing .desktop files
Group: Editors
Requires: %name = %version-%release
BuildArch: noarch

%description -n emacs-mode-%emacs_mode
emacs-mode-%emacs_mode provides support for editing freedesktop.org
desktop entry files.

All Emacs Lisp code is byte-copmpiled, install emacs-mode-%emacs_mode-el for sources.

%package -n emacs-mode-%emacs_mode-el
Summary: The Emacs Lisp sources for bytecode included in emacs-mode-%emacs_mode
Group: Development/Lisp
BuildArch: noarch

%description -n emacs-mode-%emacs_mode-el
emacs-mode-%emacs_mode provides support for editing freedesktop.org
desktop entry files.

emacs-mode-%emacs_mode-el contains the Emacs Lisp sources for the bytecode
included in the emacs-mode-%emacs_mode package, that extends the Emacs editor.

You need to install emacs-mode-%emacs_mode-el only if you intend to modify any of the
emacs-mode-%emacs_mode code or see some Lisp examples.


%prep
%setup -q
#autoreconf
sh autogen.sh

%build
%configure --disable-static --with-lispdir=%_emacslispdir
%make_build

%install
%make install DESTDIR=$RPM_BUILD_ROOT

%__mkdir_p %buildroot/%_rpmlibdir/
%__cat <<__TRIGGER__ >%buildroot/%_rpmlibdir/update-desktop-database.filetrigger
#!/bin/sh -e
export XDG_DATA_DIRS="/usr/share:/var/cache"
grep -qs -e '^/usr/share/applications/' && update-desktop-database -q ||:
__TRIGGER__
chmod 0755 %buildroot/%_rpmlibdir/update-desktop-database.filetrigger

# Create %emacs_mode-init.el
%__cat <<__INIT__ >%emacs_mode-init.el
;;; %emacs_mode-init.el --- Startup code for desktop-entry mode
;;;
    
;; load %emacs_mode-mode 
(autoload 'desktop-entry-mode "desktop-entry-mode" "Desktop entry mode." t)
(setq auto-mode-alist (append '(("\\.desktop$" . desktop-entry-mode))
  auto-mode-alist))
(setq auto-coding-alist (append '(("\\.desktop$" . utf-8)) auto-coding-alist))

__INIT__

%__install -pD -m644 %emacs_mode-init.el %buildroot%_emacs_startscriptsdir/%emacs_mode-init.el

mkdir -p %buildroot/%_desktopdir/
touch %buildroot/%_desktopdir/mimeinfo.cache

%post
%_bindir/update-desktop-database ||:

%files
%_bindir/*
%_rpmlibdir/*.filetrigger
%ghost %_desktopdir/mimeinfo.cache
%_man1dir/*

%files -n emacs-mode-%emacs_mode
%config(noreplace) %_emacs_startscriptsdir/%emacs_mode-init.el
%_emacslispdir/%emacs_mode-mode.elc

%files -n emacs-mode-%emacs_mode-el
%_emacslispdir/%emacs_mode-mode.el

%changelog
