Name: desmume
Version: 0.9.8
Release: alt1
Summary: A Nintendo DS emulator

Group: Emulators
License: GPLv2+
Packager: Ilya Mashkin <oddity@altlinux.ru>
Url: http://desmume.org/
Source0: http://downloads.sourceforge.net/%name/%name-%version.tar.gz
# Do not look into builddir
Patch0: %name-0.9-dontlookinbuilddir.patch

BuildRequires: libgtkglext-devel
BuildRequires: libglade-devel
BuildRequires: libopenal-devel
BuildRequires: liblua5-devel
BuildRequires: zziplib-devel
BuildRequires: gettext
BuildRequires: intltool
BuildRequires: libagg-devel gcc-c++
BuildRequires: desktop-file-utils
Requires: icon-theme-hicolor
BuildPreReq: chrpath


%package glade
Summary: A Nintendo DS emulator (Glade GUI version)
Group: Emulators

%package cli
Summary: A Nintendo DS emulator (CLI version)
Group: Emulators

%description
DeSmuME is a Nintendo DS emulator running homebrew demos and commercial games.

%description glade
DeSmuME is a Nintendo DS emulator running homebrew demos and commercial games.

This is the GTK/Glade version.

%description cli
DeSmuME is a Nintendo DS emulator running homebrew demos and commercial games.

This is the CLI version.

%prep
%setup
%patch0 -p1

# Fix end-of-line encoding
sed -i 's/\r//' AUTHORS

# Fix file encoding
for txtfile in ChangeLog AUTHORS
do
    iconv --from=ISO-8859-1 --to=UTF-8 $txtfile > tmp
    touch -r $txtfile tmp
    mv tmp $txtfile
done

# Fix premissions
chmod 644 src/*.{cpp,h}
chmod 644 src/gtk-glade/*.{cpp,h}
chmod 644 src/gtk-glade/dTools/*.{cpp,h}

# Fix glade path
sed -i 's|gladedir = $(datadir)/desmume/glade|gladedir = $(datadir)/desmume-glade/|g' src/gtk-glade/Makefile.{am,in}

# We need a different icon for desmume-glade
sed -i 's|Icon=DeSmuME|Icon=DeSmuME-glade|g' src/gtk-glade/desmume-glade.desktop

# Fix gettext package name
sed -i 's|GETTEXT_PACKAGE=desmume|GETTEXT_PACKAGE=desmume-glade|g' configure{,.ac}

%build
#autoreconf
%configure --enable-openal
make %{?_smp_mflags}

%install

make install DESTDIR=%buildroot

# Remove installed icon
rm %buildroot%_datadir/pixmaps/DeSmuME.xpm

# Install icons
mkdir -p %buildroot%_datadir/icons/hicolor/32x32/apps
install -m 644 src/gtk/DeSmuME.xpm %buildroot%_datadir/icons/hicolor/32x32/apps/
install -m 644 src/gtk/DeSmuME.xpm %buildroot%_datadir/icons/hicolor/32x32/apps/DeSmuME-glade.xpm

# Rename desktop files and fix categories
mkdir -p %buildroot%_datadir/applications
desktop-file-install \
  --delete-original \
  --vendor altlinux \
  --remove-key Version \
  --remove-category GNOME \
  --remove-category GTK \
  --dir %buildroot%_datadir/applications \
  %buildroot%_datadir/applications/%name.desktop

desktop-file-install \
  --delete-original \
  --vendor altlinux \
  --remove-key Version \
  --remove-category GNOME \
  --remove-category GTK \
  --dir %buildroot%_datadir/applications \
  %buildroot%_datadir/applications/%name-glade.desktop


for i in %buildroot%_libdir/*.so %buildroot%_libdir/desmume/*.so \
        %buildroot%_bindir/*
do
        chrpath -d $i ||:
done




%find_lang %name-glade


%files
%_bindir/%name
%_datadir/icons/hicolor/32x32/apps/DeSmuME.xpm
%_datadir/applications/altlinux-%name.desktop
%_mandir/man1/%name.1*
%doc AUTHORS ChangeLog COPYING README README.LIN

%files glade -f %name-glade.lang
%_bindir/%name-glade
%_datadir/%name-glade
%_datadir/icons/hicolor/32x32/apps/DeSmuME-glade.xpm
%_datadir/applications/altlinux-%name-glade.desktop
%_mandir/man1/%name-glade.1*
%doc AUTHORS ChangeLog COPYING README README.LIN

%files cli
%_bindir/%name-cli
%_mandir/man1/%name-cli.1*
%doc AUTHORS ChangeLog COPYING README README.LIN

%changelog
