%define ver_major 3.8

Name: devhelp
Version: %ver_major.2
Release: alt1

Summary: Developer's help program
Summary(be_BY.UTF-8): Сыстэма даведкі для распрацоўніка ў асяродьдзі GNOME
Summary(ru_RU.UTF-8): Справочная система для разработчика в среде GNOME
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
License: %gpl2plus
Group: Development/Other
Url: http://www.gnome.org
#VCS: git:git://git.gnome.org/devhelp
Source: %name-%version.tar
Source2: libgd.tar

# From configure.in
%define gtk_ver 3.5.6

Requires: lib%name = %version-%release

BuildPreReq: rpm-build-gnome >= 0.6 gnome-common
BuildPreReq: rpm-build-licenses
BuildPreReq: gtk-doc

# From configure.in
BuildPreReq: intltool >= 0.40.0
BuildPreReq: libgio-devel >= 2.32
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libwebkitgtk3-devel libwebkit2gtk-devel >= 1.10.0
BuildPreReq: zlib-devel
BuildPreReq: gettext-tools

%description
A developers help program.

%description -l be_BY.UTF-8
Даведкавая сыстэма для распрацоўніка у асяродзьдзі GNOME.

%description -l ru_RU.UTF-8
Справочная система для разработчика в среде GNOME.

%package -n lib%name
Summary: Devhelp widgets library
Summary(be_BY.UTF-8): Бібліятэка віджэтаў Devhelp
Summary(ru_RU.UTF-8): Библиотека виджетов Devhelp
Group: System/Libraries

%description -n lib%name
This package provides shared library required for Devhelp to work.

%description -l be_BY.UTF-8 -n lib%name
Гэты пакет утрымлівае неабходную для працы Devhelp бібіліятэку.

%description -l ru_RU.UTF-8 -n lib%name
Пакет предостовляет необходимую для работы  Devhelp библиотеку.

%package -n lib%name-devel
Summary: Devhelp widgets headers
Summary(be_BY.UTF-8):	Файлы распрацоўкі патрэбныя для пабудовы дастасаваньняў з %name
Summary(ru_RU.UTF-8):	Файлы разработки нужные для построения приложений с %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Devhelp widgets.

%description -n lib%name-devel -l be_BY.UTF-8
Файлы распрацоўкі патрэбныя для пабудовы дастасаваньняў з %name

%description -n lib%name-devel -l ru_RU.UTF-8
Файлы разработки нужные для построения приложений с %name

%package -n gedit-plugin-%name
Summary: DevHelp integration into GEdit
Group: Development/Other

%description -n gedit-plugin-%name
This plugin for GEdit enables using DevHelp from inside the editor.

%define _devhelpdir %_datadir/%name
%define  gedit_pluginsdir %_libdir/gedit/plugins

%prep
%setup -q
tar -xf %SOURCE2 -C libgd

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
	--disable-static \
	--disable-schemas-install

%make_build

%install
%make_install install DESTDIR=%buildroot

# Create some directories in %name hierarchy
mkdir -p %buildroot%_devhelpdir/{specs,books}

%find_lang %name

%files -f %name.lang
%_bindir/*
%dir %_devhelpdir
%_devhelpdir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/devhelp.*
%_datadir/GConf/gsettings/*.convert
%_datadir/glib-2.0/schemas/*.gschema.xml
%doc AUTHORS COPYING NEWS README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lib%name-*.pc

%files -n gedit-plugin-%name
%gedit_pluginsdir/*

%changelog
