Name: dhcpcd
Epoch: 1
Version: 5.6.8
Release: alt2.M70P.1

Summary: DHCP Client
License: %bsdstyle
Group: System/Servers

URL: http://roy.marples.name/projects/%name
Source: %name-%version.tar
Source2: 70-vendor-encap
Patch0: %name-%version-%release.patch
AutoReq: yes, noshell

BuildRequires: rpm-build-licenses

Conflicts: etcnet < 0.9.10-alt6

# NetworkManager can use dhcpcd
Provides: nm-dhcp-client

%description
dhcpcd is an implementation of the DHCP client specified in RFC2131.

It gets the host information (IP address, netmask, broadcast address, etc.)
from a DHCP server and configures the network interface of the machine on
which it is running. It also tries to renew the lease time according to RFC2131.

%prep
%setup -q
%patch0 -p1

%build
%configure \
        --sbindir=/sbin \
        --rundir=/var/run \
        --libexecdir=/lib/%name \
        --dbdir=%_localstatedir/%name \
        --serviceexists='[ -x %_initdir/"$1" ]' \
        --servicecmd='/sbin/service "$1" >/dev/null 2>&1' \
        --with-hook=ntp.conf
%make_build

%install
%makeinstall_std BINMODE=0755
install -m 0644 %SOURCE2 %buildroot/lib/%name/%name-hooks/

%triggerpostun -- %name < 1:5.0.0
if grep -qs '^[[:blank:]]*clientid' %_sysconfdir/%name.conf; then
	echo "WARNING: *clientid* option is detected in %_sysconfdir/%name.conf."
	echo "The behavior of this option was changed since dhcpcd-5."
	echo "Now it means TO SEND clientid to the server."
fi

%files
/sbin/*
%_man8dir/*
%_man5dir/*
%config(noreplace) %_sysconfdir/%name.conf
%dir %_localstatedir/%name
%dir /lib/%name
%dir /lib/%name/%name-hooks
/lib/%name/%name-hooks/*
/lib/%name/%name-run-hooks

%changelog
