Name: dirmngr
Version: 1.1.1
Release: alt0.M70P.1

Summary: Client for Managing/Downloading CRLs
Group: System/Libraries
License: GPLv2+
Url: http://www.gnupg.org/

# ftp://ftp.gnupg.org/gcrypt/dirmngr/%name-%version.tar.bz2
Source: %name-%version.tar

BuildRequires: libassuan-devel libgcrypt-devel libksba-devel libldap-devel libpth-devel

%description
Dirmngr is a server for managing and downloading certificate
revocation lists (CRLs) for X.509 certificates and for downloading
the certificates themselves.  Dirmngr also handles OCSP requests as
an alternative to CRLs.  Dirmngr is either invoked internally by
gpgsm (from gnupg2) or when running as a system daemon through
the dirmngr-client tool.

%prep
%setup
%autoreconf

%build
%define docdir %_docdir/%name-%version
%configure \
	--disable-rpath \
	--libexecdir=%_libexecdir/dirmngr \
	--docdir=%docdir
%make_build

%install
%makeinstall_std
install -pm644 AUTHORS NEWS README THANKS %buildroot%docdir/
%find_lang %name

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_libexecdir/dirmngr/
%_infodir/*.info*
%_man1dir/*
%docdir

%changelog
