Name: dosemu
Version: 1.4.1
Release: alt0.1
Epoch: 1

Summary: The Linux DOS emulator
Summary(ru_RU.UTF-8): Эмулятор DOS под Linux
License: GPLv2
Group: Emulators
Url: http://dosemu.sourceforge.net/
Packager: Grigory Batalov <bga@altlinux.ru>

# https://dosemu.svn.sourceforge.net/svnroot/dosemu/trunk
Source: %name-svn.tar

# icons from Mandrake
Source2: xdosemu.xpm
Source3: xdosemu-mini.xpm
Source4: xdosemu-large.xpm

# sources and precompiled fonts
Source9: dosemu-1.4.0-alt-fonts.tar

# default /etc/dosemu.users
Source13: dosemu.users

Patch: %name-%version-%release.patch

Obsoletes: dosemu-bin-nox
Conflicts: dosemu-freedos < 050405-alt3
Conflicts: dosemu-bin-x

%define docdir %_docdir/%name-%version

# Automatically added by buildreq on Tue Sep 25 2012
# optimized out: alternatives libX11-devel xorg-kbproto-devel xorg-xextproto-devel xorg-xf86vidmodeproto-devel xorg-xproto-devel
BuildRequires: flex imake libICE-devel libSDL-devel libXext-devel libXxf86vm-devel libalsa-devel libgpm-devel libslang2-devel libsndfile-devel

%description
This package allows MS-DOS programs to be started in Linux. A virtual
machine (the DOS box) provides the necessary BIOS functions and emulates
most of the chip devices (e.g. timer, interrupt- and keyboard controler)
Documentation can be found in %docdir and in the man
page, as well as in the sources.
You probably need dosemu-freedos package too.

%description -l ru_RU.UTF-8
DOSEmu позволяет запускать программы MS-DOS под Linux. Виртуальная
машина (DOS) предоставляет необходимые функции BIOS и эмулирует
большинство устройств, таких как таймер, контроллеры прерываний
и клавиатуры. Документацию можно найти в %docdir
и на страницах руководства (man). Как, впрочем, и в исходниках.
Вероятно, вам также понадобится пакет dosemu-freedos.

%package plugins-x-sdl
Summary: Dosemu X11 and SDL plugins
Group: Emulators
Requires: dosemu = %epoch:%version-%release
Obsoletes: xdosemu
Obsoletes: dosemu-bin-x

%description plugins-x-sdl
The Linux DOS Emulator XFree86/Xorg and SDL plugins.

%package plugins-sound
Summary: Dosemu ALSA and Sndfile plugins
Group: Emulators
Requires: dosemu = %epoch:%version-%release

%description plugins-sound
The Linux DOS Emulator ALSA and Sndfile plugins.

%prep
%setup -n %name-svn

cp -f compiletime-settings.devel compiletime-settings
%patch -p1

sed -i -e "s!#[[:space:]]*\(\$_cli_timeout[[:space:]]*=[[:space:]]*\)(.*!\1(10)!g" etc/dosemu.conf
sed -i -e "s!#[[:space:]]*\(\$_ttylocks[[:space:]]*=[[:space:]]*\)\".*!\1\"/var/lock/serial\"!g" etc/dosemu.conf

# copy sources and precompiled VGA fonts
tar xf %SOURCE9 -C etc
gzip etc/*.pcf

# to avoid automatic autoreconf call
#touch configure.ac configure

%build
# TODO: why not try to disable these plugins?
sed -i -e "s! x off! x on!g" compiletime-settings
sed -i -e "s! plugin_sdl off! plugin_sdl on!g" compiletime-settings
%configure --with-pthreads
%make_build WAIT=no prefix=%_prefix

%install
# install itself
%makeinstall_std prefix=%prefix mandir=%_mandir docdir=%docdir
# /var/lib/dosemu for custom DOS
mkdir -p %buildroot%_localstatedir/dosemu

# default /etc/dosemu.users
install -m644 %SOURCE13 %buildroot%_sysconfdir/dosemu.users
# copy icons
mkdir -p %buildroot{%_niconsdir,%_liconsdir,%_miconsdir}
install -m644 %SOURCE2 %buildroot%_niconsdir/xdosemu.xpm
install -m644 %SOURCE3 %buildroot%_miconsdir/xdosemu.xpm
install -m644 %SOURCE4 %buildroot%_liconsdir/xdosemu.xpm
# adjusting docs
#mv %buildroot%_sysconfdir/%name/global.conf %buildroot%docdir
install -m644 doc/HP1100-cp866-fonts-HOWTO.txt %buildroot%docdir/

# Menu entry for xdosemu
mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/x%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=X DOS emulator
Comment=DOS emulator running under X
Icon=xdosemu
Exec=xdosemu
Terminal=false
Categories=System;Emulator;
EOF

# Be compatible with package upgrade
mv %buildroot%_datadir/%name/drive_z %buildroot%_datadir/%name/freedos
ln -s freedos %buildroot%_datadir/%name/drive_z
# Provide default autoexec.bat and config.sys
install -m644 dist/{autoexec.bat,config.sys} %buildroot%_datadir/%name/freedos/

%pre
# Prevent alternative update during older package removal
[ -f %_altdir/dosemu-bin-nox.xml ] && rm -f %_altdir/dosemu-bin-nox.xml ||:
[ -f %_altdir/dosemu-bin-x.xml ] && rm -f %_altdir/dosemu-bin-x.xml ||:

%post plugins-x-sdl
# (making fontlist)
if [ -x %_x11bindir/mkfontdir ]; then
   (cd %_datadir/dosemu/Xfonts; %_x11bindir/mkfontdir)
fi

%preun plugins-x-sdl
# (removing fontlist)
if [ $1 = "0" -a -f %_datadir/dosemu/Xfonts/fonts.dir ]; then
   rm -f %_datadir/dosemu/Xfonts/fonts.dir
fi

%files
%config(noreplace) %_sysconfdir/dosemu.conf
%config(noreplace) %_sysconfdir/dosemu.users
%config(noreplace) %_sysconfdir/global.conf
%exclude %_bindir/xdosemu*
%_bindir/*
%dir %_localstatedir/dosemu
%dir %_datadir/dosemu
%exclude %_datadir/dosemu/Xfonts
%_datadir/dosemu/*
%docdir
%exclude %_man1dir/xdosemu.*
%_man1dir/*
%dir %_libdir/%name/
%_libdir/%name/libplugin_gpm.so
%_libdir/%name/libplugin_term.so

%files plugins-x-sdl
%_bindir/xdosemu*
%_desktopdir/xdosemu.desktop
%_libdir/%name/libplugin_sdl.so
%_libdir/%name/libplugin_X.so
%_datadir/dosemu/Xfonts
%_niconsdir/xdosemu.xpm
%_miconsdir/xdosemu.xpm
%_liconsdir/xdosemu.xpm
%doc %_man1dir/xdosemu.*

%files plugins-sound
%_libdir/%name/libplugin_alsa.so
%_libdir/%name/libplugin_sndfile.so

%changelog
