Name: doxygen
Version: 1.7.6.1
Release: alt1
Epoch: 1

Summary: Doxygen is a documentation system for C, C++ and IDL
License: GPLv2+
Group: Development/Other
Url: http://www.doxygen.org/

# ftp://ftp.stack.nl/pub/users/dimitri/doxygen-%version.src.tar.gz
Source: doxygen-%version.src.tar
Patch: doxygen-1.7.5-rh-timestamp.patch

# Automatically added by buildreq on Sun Aug 02 2009
BuildRequires: flex gcc-c++ graphviz libqt4-devel python-modules-xml texlive-extra-utils texlive-generic-recommended texlive-publishers

%description
Doxygen is a documentation system for C, C++ and IDL.  It can generate
an on-line class browser (in HTML) and/or an off-line reference manual
(in LaTeX) from a set of documented source files.  There is also support
for generating man pages and for converting the generated output into
Postscript, hyperlinked PDF or compressed HTML.  The documentation is
extracted directly from the sources.

Doxygen can also be configured to extract the code-structure from
undocumented source files.  This can be very useful to quickly find
your way in large source distributions.

%package wizard
Summary: GUI frontend for doxygen
Group: Development/Other
Requires: %name = %epoch:%version-%release

%description wizard
Doxywizard is a GUI front-end for creating and editing
configuration files that are used by doxygen.

%package doc
Summary: Documentation and examples for doxygen
Group: Development/Other
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description doc
This package contains doxygen examples and documentation in html and
pdf formats.

%prep
%setup
%patch -p1

find -name unistd.h -delete -print
perl -pi -e '
	s|^(TMAKE_CFLAGS\s*=\s*).*|$1\$(RPM_OPT_FLAGS)|;
	s|^(TMAKE_CFLAGS_WARN_ON\s*=).*|$1|;
	s|^(TMAKE_CFLAGS_WARN_OFF\s*=).*|$1|;
	s|^(TMAKE_CFLAGS_RELEASE\s*=).*|$1|;
	s|^(TMAKE_CFLAGS_DEBUG\s*=).*|$1|;
	s|^(TMAKE_CFLAGS_SHLIB\s*=\s*).*|$1%optflags_shared|;
	s|/usr/X11R6/lib|/usr/X11R6/%_lib|;
	' tmake/lib/linux-g++/tmake.conf

%build
# Exceptions and RTTI are used only in addon/xmlread, which is not built.
%add_optflags %optflags_nocpp

export QTDIR=%_libdir/qt4
export PATH="$QTDIR/bin:$PATH"
./configure --prefix %prefix --release --with-doxywizard
make
make pdf

%install
mkdir -p %buildroot{%_bindir,%_man1dir}
install -pm755 bin/* %buildroot%_bindir/
install -pm644 doc/*.1 %buildroot%_man1dir/

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir/pdf
install -pm644 latex/*.pdf %buildroot%docdir/pdf/
cp -a html examples %buildroot%docdir/
find %buildroot%docdir/ -type f -name Makefile.\* -delete
find %buildroot%docdir/ -type f -name Makefile -print0 |
	xargs -r0 perl -pi -e '
	s|/bin/doxygen||g;
	s|^(DOXYGEN\s*=\s*).*|$1%_bindir/doxygen|;
	s|^(TMAKE\s*=\s*).*|$1%_bindir/tmake|;
	s/^(TMAKEPATH|INST|DOXYDOCS).*//g;
	' --

%files
%_bindir/doxygen
%_bindir/doxytag
%_man1dir/doxygen.*
%_man1dir/doxytag.*

%files wizard
%_bindir/doxywizard
%_man1dir/doxywizard.*

%files doc
%docdir

%changelog
