Name: drpython
Version: 3.11.0
Release: alt1.1.qa2.1
Epoch: 1

Summary: Python editor and development environment
Summary(ru_RU.KOI8-R):       Python

Url: http://drpython.sourceforge.net/
License: GPL
Group: Development/Python

Source: http://prdownloads.sf.net/%name/%name-%version.tar.bz2
Source1: %name.desktop

Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

BuildPreReq: python-devel
BuildRequires: ImageMagick, rpm-build-compat >= 1.2
Requires: python-module-wx >= 2.6
Requires: webclient
BuildRequires: desktop-file-utils

%description
DrPython is a highly customizable, simple, and clean editing environment for
developing Python programs. It is intended primarily for use in schools, and
is a tribute to DrScheme.

%description -l ru_RU.KOI8-R
DrPython --        
 Python,      .
    DrScheme.

%prep
%setup -q -n %name
chmod 644 %name.py

# Fix default paths to docs
sed -i "s/mozilla/url_handler.sh/" drPreferences.py
sed -i "s|http://www.python.org/doc/current/|%_docdir/python-doc-2.4.2/index.html|" drPreferences.py
sed -i "s|http://www.wxwidgets.org/docs.htm|%_docdir/wxGTK2-doc-2.6.2|" drPreferences.py

# Change Windows line endings to Unix line endings
for file in $(find *.txt *.TXT -type f); do
  sed -i 's/\r//' $file
done

# Remove Windows related files and patch the setup.py file so it doesn't rely on the file
rm -rf tools/
rm -f setup.cfg

%build
%python_build

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_datadir/%name
mkdir -p %buildroot%_datadir/%name/documentation
cp *.py* %buildroot%_datadir/%name
cp -r examples bitmaps %buildroot%_datadir/%name
cp -r documentation/* %buildroot%_datadir/%name/documentation/

echo '#!/bin/bash' > %buildroot%_bindir/%name
#echo 'cd %_datadir/%name' >> %buildroot%_bindir/%name
echo 'python %_datadir/%name/drpython.py' >> %buildroot%_bindir/%name
chmod 755 %buildroot%_bindir/%name

install -D -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop

#icons
mkdir -p %buildroot%_liconsdir
convert -size 16x16 documentation/%name.png %buildroot%_liconsdir/%name.png
mkdir -p %buildroot%_niconsdir
convert -size 32x32 documentation/%name.png %buildroot%_niconsdir/%name.png
mkdir -p %buildroot%_miconsdir
convert -size 48x48 documentation/%name.png %buildroot%_miconsdir/%name.png

rm -rf %buildroot%_datadir/drpython/bitmaps/24/.xvpics
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=IDE \
	%buildroot%_desktopdir/drpython.desktop

%files
%doc examples/ *.txt
%_bindir/%name
%_datadir/%name/
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_niconsdir/%name.png
%_miconsdir/%name.png

%changelog
