Name: dynamips
Version: 0.2.8
%define extra_ver RC3
Release: alt2%extra_ver

Summary: Cisco 7200 Simulator
License: GPLv2
Group: Emulators

Url: http://www.gns3.net/

Source: %name-%version-RC3-community.tar.gz
Patch1: %name-0.2.8-RC3-make.patch

BuildRequires: libelf-devel libpcap-devel libuuid-devel

%description
A project to emulate a Cisco 7200 on a traditionnal PC.
The emulator currently supports the following platforms:
 - Cisco 7200 (NPE-100 to NPE-400)
 - Cisco 3600 (3620, 3640 and 3660)
 - Cisco 2691
 - Cisco 3725
 - Cisco 3745
 - Cisco 2600 (2610 to 2650XM)
 - Cisco 1700 (1710 to 1760)

The goals of this emulator are mainly:
    * To be used as a training platform, with software used in real world. It
      would allow people to become more familiar with Cisco devices, Cisco
      being the world leader in networking technologies ;
    * Test and experiment the numerous and powerful features of Cisco IOS ;
    * Check quickly configurations to be deployed later on real routers.

%prep
%setup -q -n %name-%version-%extra_ver-community
%patch1 -p1

%build
%make

%install
%makeinstall_std
install -d %buildroot%_localstatedir/%name/{labs,images}

%files
%doc COPYING README* TODO stable/ChangeLog
%_man1dir/*
%_man7dir/hypervisor_mode.7*
%_bindir/*
%dir %_localstatedir/%name/images
%dir %_localstatedir/%name/labs

%changelog
