%define _name enlightenment
%define cvs_date zero
%undefine cvs_date
%define snapshot 2012-10-12
%define rel alt1

%def_disable static
%def_with pam_helper

# TODO: pam CoreFoundation

Name: e17
Version: 0.17.3

%ifdef cvs_date
Release: %rel.%cvs_date
%else
Release: %rel
%endif
Serial: 1

Summary: The Enlightenment window manager
License: BSD
Group: Graphical desktop/Enlightenment
URL: http://www.enlightenment.org/

Source: http://download.enlightenment.org/releases/%_name-%version.tar.bz2

Source1: E-17.xpm
Source2: start%name
Source3: %name.wmsession
Source6: %name.xpm
Source7: %name-32.xpm
Source8: %_name.desktop
Source9: %_name-wm.desktop

# Some missing source files from the SVN tree
Source10: %_name.missing-%version.tar
Source11: e17-alt-sysactions.conf

Patch0: fix-systray-height.patch
Patch1: add-systray-mobile.patch
Patch2: add-systray-standard.patch
Patch3: illume-keyboard-bigfont.patch
Patch4: e17-0.17.0-alt-g-s-d_path.patch
Patch5: e17-0.17.1-alt-e_sys_nosuid.patch
Patch6: auto-ptrace-disable.patch
Patch11: enlightenment-0.17.1-pam-helper.patch

Provides: e17-default
# default terminal
Requires: terminology
Requires: evas_generic_loaders dbus-tools-gui edbus eeze
Requires: empower
Requires: pm-utils
# for menu
Requires: gnome-icon-theme
Requires: wm-common-freedesktop
Requires: altlinux-freedesktop-menu-%_name >= 0.55
%{?_with_pam_helper:Requires: chkpwd-pam}

BuildPreReq: libeet-devel >= 1.7.7
BuildPreReq: libecore-devel >= 1.7.7
BuildPreReq: libeio-devel >= 1.7.7
BuildRequires: libpam-devel libX11-devel libevas-devel libecore-devel
BuildRequires: edje libedje-devel libeet-devel libeet-utils libembryo-devel libefreet-devel
BuildRequires: libXext-devel embryo_cc libdbus-devel libedbus-devel
BuildRequires: libalsa-devel libeina-devel eeze libeeze-devel libemotion-devel libelementary-devel
BuildRequires: libudev-devel libxcbutil-keysyms-devel pm-utils
BuildRequires: doxygen
BuildRequires: libp11-kit-devel

%description
Enlightenment is a window manager.
E-17 is a non-stable Enlightenment version from CVS.
	
%package devel
Summary: Development headers for Enlightenment.
Group: Development/C
Requires: %name = %serial:%version-%release

%description devel
Development headers for Enlightenment.

%package gnome
Summary: GNOME-specific parts of Enlightenment
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-wm
Requires: %name = %serial:%version-%release
Requires: gnome-session >= 2.24

%description gnome
Install this package and run:
"gconftool-2 --set --type string /desktop/gnome/session/required_components/windowmanager enlightenment"
to use Enlightenment as windowmanager in GNOME 2 session

%prep
%ifdef cvs_date
%setup -q -n %_name-%version-%cvs_date -a10
%else
%setup -q -n %_name-%version -a10
%endif
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p1 -b .gsd
%patch5 -p1 -b .nosuid
%patch6 -p2
%patch11 -p1

%build
%autoreconf
export CFLAGS="$CFLAGS `pkg-config --cflags dbus-1` -g -ggdb3"
%configure \
	--with-profile=FAST_PC \
	--enable-files \
	%{subst_enable static} \
	--enable-shared \
	--enable-mount-eeze \
	--enable-pam \
%if_with pam_helper
	--with-pam-helper=%prefix/libexec/chkpwd-pam/chkpwd-pam \
%endif
	--disable-mount-hal

%make_build
%make doc
%install
%make_install DESTDIR=%buildroot install

mkdir -p %buildroot%_rpmmacrosdir
cat > %buildroot%_rpmmacrosdir/e17 <<_EOF_
%%e17_version		%version
_EOF_

%find_lang enlightenment

mkdir -p %buildroot%_sysconfdir/X11/wmsession.d
mkdir -p %buildroot%_bindir/
install -p -m755 %SOURCE2 %buildroot%_bindir/
install -D -pm 644 %SOURCE3 %buildroot%_sysconfdir/X11/wmsession.d/05E-17

# Install icons
install -pD -m644 %SOURCE6 %buildroot%_miconsdir/%name.xpm
install -pD -m644 %SOURCE7 %buildroot%_niconsdir/%name.xpm
install -p -m644 %SOURCE1 %buildroot%_niconsdir/

# desktop file
install -pD -m 644 %SOURCE8 %buildroot%_datadir/applications/enlightenment.desktop
# be gnome-wm
install -pD -m 644 %SOURCE9 %buildroot%_datadir/gnome/wm-properties/enlightenment-wm.desktop

# PAM-config
mkdir -p %buildroot%_sysconfdir/pam.d
cat > %buildroot%_sysconfdir/pam.d/enlightenment << _PAM_
#%%PAM-1.0

auth		include		system-auth
account		required	pam_deny.so
password	required	pam_deny.so
session		required	pam_deny.so
_PAM_

# replace original sysaction.conf
cp %SOURCE11 %buildroot%_sysconfdir/enlightenment/sysactions.conf

%find_lang enlightenment

%files -f enlightenment.lang
%config %_sysconfdir/X11/wmsession.d/*
%config %_sysconfdir/enlightenment/sysactions.conf
%config(noreplace) %_sysconfdir/pam.d/enlightenment
%dir %_libdir/enlightenment/
%_libdir/enlightenment/*
%_niconsdir/*.xpm
%_miconsdir/*.xpm
%_bindir/*
%_datadir/enlightenment/
%_datadir/xsessions/enlightenment.desktop
%_datadir/applications/*.desktop
%doc AUTHORS COPYING README

%files devel
%dir %_includedir/enlightenment/
%_includedir/enlightenment/*.h
%_libdir/pkgconfig/enlightenment.pc
%_libdir/pkgconfig/everything.pc
%_rpmmacrosdir/%name

%files gnome
%_datadir/gnome/wm-properties/*.desktop

%changelog
