%def_disable static

Name: ecore
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Serial: 1

Summary: Enlightened Core X interface library
License: BSD
Group: System/Libraries

Url: http://www.enlightenment.org/
Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2

%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildPreReq: libeet-devel >= 1.7.7
BuildPreReq: libevas-devel >= 1.7.7 libeina-devel >= 1.7.7

BuildRequires: fontconfig-devel libcurl-devel libdirectfb-devel libevas-devel
BuildRequires: libfreetype-devel libICE-devel libjpeg-devel libXcursor-devel
BuildRequires: libXdamage-devel libXinerama-devel libXp-devel libXrandr-devel
BuildRequires: libXScrnSaver-devel libXfixes-devel
BuildRequires: libXext-devel libXrender-devel libXcomposite-devel libXtst-devel
BuildRequires: libssl-devel libgnutls-devel libgcrypt-devel glib2-devel doxygen

%description
Ecore is a nice convenience library. It handles abstracting X calls so
you don't have to pass as many parameters to them. It wraps lots of
other sequences of X calls you want to do often, handles caching local
geometry of windows to save extra X traffic, abstracts X's events and
adds a timer system to be able to do timeouts, handles the core event
loops, abstracts signals into being events in the event queue, and lets
you arbitrarily add other file descriptors to the loop to listen on and
have handlers be called when they become active, and much much more.
Ecore also handles filtering events and calling idle handlers when
appropriate. Ecore is just what it says - a very complex CORE subsystem.
It is all callback based, and keeps everything abstracted - but does not
move away from normal X11 primitives like other abstractions (GDK for
example), thus keeping 100 percent compatibility with normal Xlib stuff.
The core innards of E17 rely heavily on Ecore and its ability to not just
work, but work well and optimize silently for E17.

%package -n lib%name
Summary: Enlightened Core X interface library
Group: System/Libraries

%description -n lib%name
Ecore is a nice convenience library. It handles abstracting X calls so
you don't have to pass as many parameters to them. It wraps lots of
other sequences of X calls you want to do often, handles caching local
geometry of windows to save extra X traffic, abstracts X's events and
adds a timer system to be able to do timeouts, handles the core event
loops, abstracts signals into being events in the event queue, and lets
you arbitrarily add other file descriptors to the loop to listen on and
have handlers be called when they become active, and much much more.
Ecore also handles filtering events and calling idle handlers when
appropriate. Ecore is just what it says - a very complex CORE subsystem.
It is all callback based, and keeps everything abstracted - but does not
move away from normal X11 primitives like other abstractions (GDK for
example), thus keeping 100 percent compatibility with normal Xlib stuff.
The core innards of E17 rely heavily on Ecore and its ability to not just
work, but work well and optimize silently for E17.

This package contains shared Ecore library.

%package -n lib%name-devel
Summary: Ecore headers and development libraries
Group: Development/C
Requires: lib%name = %serial:%version-%release

%description -n lib%name-devel
This package contains Ecore headers and development libraries

%package -n lib%name-devel-static
Summary: Ecore static libraries.
Group: Development/C
Requires: lib%name-devel = %serial:%version-%release

%description -n lib%name-devel-static
This package contains Ecore static libraries.

%prep
%ifdef beta
%setup -q -n %name-%version.%beta
%else
%setup -q
%endif

%build
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static}
%make_build
%make doc

%install
%make_install DESTDIR=%buildroot install

%find_lang %name

%files -n lib%name -f %name.lang
%_libdir/libecore*.so.*
%dir %_libdir/%name/
%dir %_libdir/%name/immodules
%_libdir/%name/immodules/xim.so
%exclude %_libdir/%name/immodules/xim.la
%doc AUTHORS COPYING INSTALL README

%files -n lib%name-devel
%_libdir/libecore*.so
%_includedir/*
%_pkgconfigdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
