%define _name e_dbus
%def_disable static

Name: edbus
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: Enlightenment DBUS access library
License: BSD-like
Group: System/Libraries
Url: http://www.enlightenment.org/

Source: http://download.enlightenment.org/releases/%_name-%version.tar.bz2

Requires: lib%name = %version-%release

%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires: libdbus-devel  libevas-devel >= 1.7.7
BuildRequires: libecore-devel >= 1.7.7 libeina-devel >= 1.7.7
BuildRequires: doxygen

%description
This is the start of some basic convenience wrappers around dbus to ease
integrating dbus with EFL based applications.

%package -n lib%name
Summary: Enlightenment DBUS access library
Group: System/Libraries

%description -n lib%name
This is the start of some basic convenience wrappers around dbus to ease
integrating dbus with EFL based applications.

This package contains shared library required for %name-based software.

%package -n lib%name-devel
Summary: Include files for development with Enlightenment DBUS Library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This is the start of some basic convenience wrappers around dbus to ease
integrating dbus with EFL based applications.

This package contains include files required for development %name-based software.

%package -n lib%name-devel-static
Summary: Static library for development with Enlightenment DBUS Library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This is the start of some basic convenience wrappers around dbus to ease
integrating dbus with EFL based applications.

This package contains static library required for development statically linked
%name-based software.

%prep
%ifdef beta
%setup -q -n %_name-%version.%beta
%else
%setup -q -n %_name-%version
%endif

%build
%autoreconf
%configure \
	%{subst_enable static}
%make_build
%make doc

%install
%make_install DESTDIR=%buildroot install

%files
%_bindir/*

%files -n lib%name
%_libdir/*.so.*
%_datadir/e_dbus/logo.png
%doc AUTHORS COPYING README

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
