%def_disable static

Name: edje
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: Complex Graphical Design/Layout Engine
License: BSD
Group: Graphical desktop/Enlightenment
URL: http://www.enlightenment.org

Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2
# temporarily fix for
# /usr/include/bits/string3.h:52:3: error: call to __builtin___memcpy_chk will always overflow destination buffer
# at edje_calc.c
Patch: edje-1.1.0-alt-buffer-overflow.patch

%{?_enable_static:BuildPreReq: glibc-devel-static}

Requires: shared-mime-info
Requires: lib%name = %version-%release
Requires: embryo_cc

BuildRequires: libeina-devel >= 1.7.7
BuildPreReq: libecore-devel >= 1.7.7
BuildPreReq: libembryo-devel >= 1.7.7
BuildPreReq: libevas-devel >= 1.7.7
BuildPreReq: libeet-devel >= 1.7.7
BuildPreReq: libeio-devel >= 1.7.7
BuildRequires: liblua5-devel libsndfile-devel
BuildRequires: doxygen

%description
Edje purpose is to be a sequel to "Ebits" which to date has serviced the
needs of Enlightenment development for version 0.17. The original design
paramteres under which Ebits came about were a lot more restricted than
the resulting use of them, thus Edje was born. A graphical layout and
animation library for animated resizable, compressed and scalable themes.

%package -n lib%name
Summary: edje library
Group: System/Libraries

%description -n lib%name
Edje purpose is to be a sequel to "Ebits" which to date has serviced the
needs of Enlightenment development for version 0.17. The original design
paramteres under which Ebits came about were a lot more restricted than
the resulting use of them, thus Edje was born. A graphical layout and
animation library for animated resizable, compressed and scalable themes.

This package contains shared Edje library.

%package -n lib%name-devel
Summary: Edje headers and development libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Edje purpose is to be a sequel to "Ebits" which to date has serviced the
needs of Enlightenment development for version 0.17. The original design
paramteres under which Ebits came about were a lot more restricted than
the resulting use of them, thus Edje was born. A graphical layout and 
animation library for animated resizable, compressed and scalable themes.

This package contains edje headers and development libraries

%package -n lib%name-devel-static
Summary: Edje static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Edje purpose is to be a sequel to "Ebits" which to date has serviced the
needs of Enlightenment development for version 0.17. The original design
paramteres under which Ebits came about were a lot more restricted than
the resulting use of them, thus Edje was born. A graphical layout and 
animation library for animated resizable, compressed and scalable themes.

This package contains static libraries

%prep
%ifdef beta
%setup -q -n %name-%version.%beta
%else
%setup -q
%endif

%patch

%build
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static}
%make_build
%make doc

%install
%make_install DESTDIR=%buildroot install

%files -n %name
%_bindir/*
%_datadir/%name/
%_datadir/mime/packages/edje.xml
%dir %_libdir/%name/
%dir %_libdir/%name/utils
%_libdir/%name/utils/epp
%doc AUTHORS COPYING README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_pkgconfigdir/%name.pc
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif


%changelog
