%def_disable tests
%def_disable static

Name: eet
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: Library for speedy data storage, retrieval and compression.
License: BSD
Group: Graphical desktop/Enlightenment
URL: http://www.enlightenment.org/

Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2

BuildRequires: libeina-devel >= 1.7.7 libjpeg-devel libgnutls-devel libgcrypt-devel zlib-devel
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_tests:BuildRequires: libcheck-devel}
BuildRequires: doxygen

%description
Eet is a tiny library designed to write an arbitary set of chunks of data
to a file and optionally compress each chunk (very much like a zip file)
and allow fast random-access reading of the file later on. It does not
do zip as a zip itself has more complexity than is needed, and it was much
simpler to impliment this once here.

It also can encode and decode data structures in memory, as well as image
data for saving to eet files or sending across the network to other
machines, or just writing to arbitary files on the system. All data is
encoded ina platform independant way and can be written and read by any
architecture.

%package -n lib%name
Summary: Eet library
Group: System/Libraries

%description -n lib%name
Eet is a tiny library designed to write an arbitary set of chunks of data
to a file and optionally compress each chunk (very much like a zip file)
and allow fast random-access reading of the file later on. It does not
do zip as a zip itself has more complexity than is needed, and it was much
simpler to impliment this once here.

It also can encode and decode data structures in memory, as well as image
data for saving to eet files or sending across the network to other
machines, or just writing to arbitary files on the system. All data is
encoded ina platform independant way and can be written and read by any
architecture.

This package contains shared Eet library.

%package -n lib%name-devel
Summary: Eet headers and development libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains Eet headers and development libraries

%package -n lib%name-devel-static
Summary: Eet static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries

%package -n lib%name-utils
Summary: Utils for eet library
Group: Graphical desktop/Enlightenment
Requires: lib%name = %version-%release

%description -n lib%name-utils
Utils for operate with Eet data

%prep
%ifdef beta
%setup -q -n %name-%version.%beta
%else
%setup -q
%endif

%build
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure \
	%{subst_enable static} \
	%{subst_enable tests}

%make_build
%make doc

# tmpnam used
%check
%{?_enable_tests:%make check}

%install
%make_install DESTDIR=%buildroot install

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_pkgconfigdir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n lib%name-utils
%_bindir/*

%changelog
