%def_disable static

Name: eeze
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: Enlightenment hardware manipulating package
License: BSD-like
Group: System/Libraries
Url: http://www.enlightenment.org/

Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2

Requires: lib%name = %version-%release

%{?_enable_static:BuildPreReq: glibc-devel-static}
BuildRequires: libudev-devel libeina-devel >= 1.7.7 libecore-devel >= 1.7.7
BuildRequires: libmount-devel libeet-devel
BuildRequires: doxygen

%description
Eeze is a library for manipulating devices through udev with a simple
and fast api. It interfaces directly with libudev, avoiding such
middleman daemons as udisks/upower or hal, to immediately gather device
information the instant it becomes known to the system.

This package provides eeze_disk_ls, eeze_mount, eeze_scanner and
eeze_umount utilities.

%package -n lib%name
Summary: Enlightenment hardware manipulating library
Group: System/Libraries

%description -n lib%name
Eeze is a library for manipulating devices through udev with a simple
and fast api. It interfaces directly with libudev, avoiding such
middleman daemons as udisks/upower or hal, to immediately gather device
information the instant it becomes known to the system.

This package contains shared library required for %name-based software.

%package -n lib%name-devel
Summary: Include files for development with Eeze Library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Eeze is a library for manipulating devices through udev with a simple
and fast api. It interfaces directly with libudev, avoiding such
middleman daemons as udisks/upower or hal, to immediately gather device
information the instant it becomes known to the system.

This package contains include files required for development %name-based software.

%package -n lib%name-devel-static
Summary: Static library for development with Eeze Library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Eeze is a library for manipulating devices through udev with a simple
and fast api. It interfaces directly with libudev, avoiding such
middleman daemons as udisks/upower or hal, to immediately gather device
information the instant it becomes known to the system.

This package contains static library required for development statically linked
%name-based software.

%prep
%ifdef beta
%setup -q -n %name-%version.%beta
%else
%setup -q
%endif

%build
%autoreconf
%configure \
	%{subst_enable static}
%make_build
%make doc

%install
%make_install DESTDIR=%buildroot install

%files
%_bindir/eeze_disk_ls
%_bindir/eeze_mount
%_bindir/eeze_scanner
%_bindir/eeze_umount

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS COPYING README

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
