%def_with parent
%define _without_maven 1
Requires: ehcache1-parent
BuildRequires: /proc
BuildRequires: jpackage-compat
# Copyright (c) 2000-2011, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

#def_with gcj_support
%bcond_with gcj_support
%bcond_with hibernate
%bcond_with maven
%bcond_with spring
#def_with tests
%bcond_with tests

%if %with gcj_support
%define gcj_support 0
%else
%define gcj_support 0
%endif

Summary:        Easy Hibernate Cache
Name:           ehcache
Version:        1.3.0
%define namedversion %{version}
Release:        alt7_4jpp6
Epoch:          0
License:        LGPLv2+
URL:            http://ehcache.sourceforge.net/
Group:          Development/Java
# svn export http://svn.sourceforge.net/svnroot/ehcache/branches/ehcache-1.3.0
Source0:        ehcache-1.3.0-src.tar.gz
Source1:        %{name}-settings.xml
Source2:        %{name}-%{version}-jpp-depmap.xml
Source3:        %{name}-autogenerated-files.tar.gz
Patch0:         ehcache-1.3.0-core-build.patch
Patch1:         ehcache-1.3.0-debugger-pom.patch
Patch2:         ehcache-1.3.0-core-pom.patch
Patch3:         ehcache-1.3.0-site_xml.patch
Patch4:         ehcache-1.3.0-beans_xml.patch
Patch5:         ehcache-1.3.0-pom.patch
Patch6:         ehcache-1.3.0-core-pom-nohibernate.patch
Patch7:         ehcache-1.3.0-core-pom-nohibernate-nospring.patch
Patch8:         ehcache-1.3.0-core-pom-nospring.patch
Patch9:         ehcache-1.3.0-core-site.patch
BuildRequires:  jpackage-utils
BuildRequires:  junit
BuildRequires:  ant
BuildRequires:  ant-junit
BuildRequires:  antlr
BuildRequires:  checkstyle
BuildRequires:  httpunit
BuildRequires:  nekohtml
BuildRequires:  rhino
BuildRequires:  servlet_2_5_api
BuildRequires:  apache-commons-collections
%if %with maven
BuildRequires:  maven-artifact-ant
BuildRequires:  maven2-default-skin
BuildRequires:  maven2 >= 2.0.4-10jpp
BuildRequires:  maven2-plugin-ant
BuildRequires:  maven2-plugin-antrun
BuildRequires:  maven2-plugin-checkstyle
BuildRequires:  maven2-plugin-compiler
BuildRequires:  maven2-plugin-install
BuildRequires:  maven2-plugin-jar
BuildRequires:  maven2-plugin-javadoc
BuildRequires:  maven2-plugin-project-info-reports
BuildRequires:  maven2-plugin-pmd
BuildRequires:  maven2-plugin-resources
BuildRequires:  maven2-plugin-site
BuildRequires:  maven-surefire-plugin
BuildRequires:  maven2-plugin-jxr
%endif
BuildRequires:  apache-commons-beanutils
BuildRequires:  apache-commons-collections
BuildRequires:  apache-commons-logging
BuildRequires:  jsr107cache
%if %with hibernate
BuildRequires:  hibernate2
BuildRequires:  hibernate3
%endif
%if %with spring
BuildRequires:  spring2-core
BuildRequires:  spring2-aop
BuildRequires:  spring2-test
%endif
#
Requires:  apache-commons-beanutils
Requires:  apache-commons-collections
Requires:  apache-commons-logging
Requires:  jsr107cache
Provides:  hibernate_in_process_cache
Provides:  ehcache-bootstrap = 0:%{version}-%{release}
Obsoletes:  ehcache-bootstrap
Requires(post):    jpackage-utils
Requires(postun):  jpackage-utils
Requires:          jpackage-utils
%if %{gcj_support}
BuildRequires:    java-gcj-compat-devel
%endif

%if ! %{gcj_support}
BuildArch:      noarch
%endif
Source44: import.info


%description
Ehcache is a pure Java, in-process cache with the following features:
   1. Fast
   2. Simple
   3. Acts as a pluggable cache for Hibernate 2.1, 3 and 3.1.
   4. Small foot print. Both in terms of size and memory requirements.
   5. Minimal dependencies.
   6. Fully documented. See the online Documentation, FAQ and the 
      online JavaDoc.
   7. Provides Memory and Disk stores.
   8. Comprehensively Test Coverage. See the clover test report.
   9. Scalable to hundreds of caches and large multi-cpu servers.
  10. Multiple CacheManagers per virtual machine (new in 1.2)
  11. Provides LRU, LFU and FIFO cache eviction policies. (new in 1.2)
  12. Persistent disk store which stores data between VM restarts.
  13. Supports the registration of CacheManager and CacheEventListener 
      for flexible integration(new in 1.2)
  14. Distributed caching, with fine grained control overf discovery 
      and delivery options.
  15. Pluggable distribution API  for extending distribution with 
      different mechanisms.
  16. Available under the Apache 1.1license. Ehcache's copyright and 
      licensing has been reviewed and approved by the Apache Software 
      Foundation, making ehcache suitable for use in Apache projects.
  17. Production tested. All final versions of ehcache are production 
      tested for several weeks on a large and very busy eCommerce site 
      before release.
  18. BlockingCache, SelfPopulatingCache, gzipping, caching Servlet 
      filters, and AsynchronousFaultTolerantCommandExecutor available 
      in the optional ehcache-constructs package.


%if %with hibernate
%package hibernate
Summary:        Hibernate3 cache provider in %{name}
Group:          Development/Java
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       hibernate3

%description hibernate
%{summary}.
%endif

%package javadoc
Summary:        Javadoc for %{name}
Group:          Development/Documentation
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
%{summary}.

%if %with maven
%package manual
Summary:        Documents for %{name}
Group:          Development/Documentation
BuildArch: noarch

%description manual
%{summary}.
%endif

%prep
%setup -q 
cp %{SOURCE1} settings.xml
# remove all binary libs
#find . -name "*.jar" -exec rm -f {} \;
for j in $(find . -name "*.jar"); do
       mv $j $j.no
done
%if %without maven
gzip -dc %{SOURCE3} | tar xf -
%endif

%if %with maven
%patch0 -p0 -b .sav0
%endif
%patch1 -p0 -b .sav1
%patch2 -p0 -b .sav2
%patch3 -p0 -b .sav3
%patch4 -p0 -b .sav4
%patch5 -p0 -b .sav5
%patch9 -p0 -b .sav9

%if %without hibernate
rm core/src/test/java/net/sf/ehcache/hibernate/HibernateAPIUsageTest.java
rm core/src/main/java/net/sf/ehcache/hibernate/EhCacheProvider.java
rm core/src/main/java/net/sf/ehcache/hibernate/SingletonEhCacheProvider.java
rm core/src/main/java/net/sf/ehcache/hibernate/EhCache.java
%patch6 -p0 -b .sav6
%if %without spring
#patch7 -p0 -b .sav7
%endif
%endif
%if %without spring
rm core/src/test/java/net/sf/ehcache/spring/SpringIntegrationTest.java
%if %with hibernate
%patch8 -p0 -b .sav8
%endif
%endif

%if %with maven
ln -s $(build-classpath maven2/artifact) core/tools/maven-artifact.jar
ln -s $(build-classpath maven2/artifact-ant) core/tools/maven-artifact-ant.jar
ln -s $(build-classpath maven2/artifact-manager) core/tools/maven-artifact-manager.jar
ln -s $(build-classpath maven2/error-diagnostics) core/tools/maven-error-diagnostics.jar
ln -s $(build-classpath maven2/model) core/tools/maven-model.jar
ln -s $(build-classpath maven2/profile) core/tools/maven-profile.jar
ln -s $(build-classpath maven2/project) core/tools/maven-project.jar
ln -s $(build-classpath maven2/settings) core/tools/maven-settings.jar
ln -s $(build-classpath maven-wagon/provider-api) core/tools/maven-wagon-provider-api.jar
ln -s $(build-classpath plexus/container-default) core/tools/plexus-container-default.jar
ln -s $(build-classpath plexus/utils) core/tools/plexus-utils.jar
ln -s $(build-classpath classworlds) core/tools/classworlds.jar

sed -i -e "s|<url>__JPP_URL_PLACEHOLDER__</url>|<url>file://`pwd`/.m2/repository</url>|g" settings.xml
sed -i -e "s|<url>__JAVADIR_PLACEHOLDER__</url>|<url>file://`pwd`/external_repo</url>|g" settings.xml
sed -i -e "s|<url>__MAVENREPO_DIR_PLACEHOLDER__</url>|<url>file://`pwd`/.m2/repository</url>|g" settings.xml
sed -i -e "s|<url>__MAVENDIR_PLUGIN_PLACEHOLDER__</url>|<url>file:///usr/share/maven2/plugins</url>|g" settings.xml
sed -i -e "s|<url>__ECLIPSEDIR_PLUGIN_PLACEHOLDER__</url>|<url>file:///usr/share/eclipse/plugins</url>|g" settings.xml

mkdir external_repo
ln -s %{_javadir} external_repo/JPP

mkdir -p core/target/classes
cp core/src/main/config/ehcache-failsafe.xml core/target/classes
%endif

rm -r core/src/test/java

%build
export LANG="en_US.UTF-8"
export LC_ALL="en_US.UTF-8"
%if %with maven
export MAVEN_REPO_LOCAL=$(pwd)/.m2/repository
%if 0
mkdir -p $MAVEN_REPO_LOCAL
mkdir -p $MAVEN_REPO_LOCAL/org.apache.maven/
ln -sf $(build-classpath maven2/default-skin) $MAVEN_REPO_LOCAL/org.apache.maven/maven-default-skin.jar
%endif
export MAVEN_SETTINGS=$(pwd)/settings.xml
%{_bindir}/mvn-jpp \
        -e \
        -s ${MAVEN_SETTINGS} \
        -Dmaven2.jpp.mode=true \
        -Dmaven2.jpp.depmap.file=%{SOURCE2} \
        -Dmaven.repo.local=${MAVEN_REPO_LOCAL} \
        -Dmaven.test.failure.ignore=true \
%if %with tests
        -Dmaven.test.skip=false \
        -Dtest.unit.skip=false \
        -Dtest.int.skip=false \
%else
        -Dmaven.test.skip=true \
        -Dtest.unit.skip=true \
        -Dtest.int.skip=true \
%endif
        ant:ant install javadoc:aggregate
%else
export CLASSPATH=$(%{_bindir}/build-classpath \
backport-util-concurrent \
commons-httpclient \
commons-collections \
%if %with hibernate
hibernate2 \
hibernate3 \
%endif
httpunit \
jsr107cache \
servlet_2_5_api \
%if %with spring
spring2/test \
%endif
)
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd core
%{ant} -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -f maven-build.xml -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
CLASSPATH=$CLASSPATH:$(pwd)/core/target/%{name}-%{namedversion}.jar
pushd debugger
%{ant} -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -f maven-build.xml -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
%endif

mkdir core/target/dist
cp core/target/%{name}-%{namedversion}.jar \
           core/target/dist/%{name}-hibernate-%{namedversion}.jar
mkdir temp
pushd temp
%{jar} xf ../core/target/%{name}-%{namedversion}.jar
rm -rf net/sf/ehcache/hibernate/
%{jar} cmf META-INF/MANIFEST.MF ../core/target/dist/%{name}-%{namedversion}.jar *
popd

%install

# jars
mkdir -p %{buildroot}%{_javadir}
install -p -m 644 core/target/dist/%{name}-%{namedversion}.jar \
  %{buildroot}%{_javadir}/%{name}-%{version}.jar
%if %with hibernate
install -p -m 644 core/target/dist/%{name}-hibernate-%{namedversion}.jar \
  %{buildroot}%{_javadir}/%{name}-hibernate-%{version}.jar
%endif
install -p -m 644 debugger/target/%{name}-debugger-%{namedversion}.jar \
  %{buildroot}%{_javadir}/%{name}-debugger-%{version}.jar
(cd %{buildroot}%{_javadir} 
  ln -s %{name}-%{version}.jar %{name}.jar
  ln -s %{name}-debugger-%{version}.jar %{name}-debugger.jar
%if %with hibernate
  ln -sf %{name}-hibernate-%{version}.jar %{name}-hibernate.jar
%endif
)
%add_to_maven_depmap net.sf.ehcache %{name} %{version} JPP %{name}
%add_to_maven_depmap net.sf.ehcache %{name}-debugger %{version} JPP %{name}-debugger
%add_to_maven_depmap net.sf.ehcache %{name}-parent %{version} JPP/%{name} ecache-parent

# poms
install -d -m 755 %{buildroot}%{_datadir}/maven2/poms
install -p -m 644 pom.xml \
    %{buildroot}%{_datadir}/maven2/poms/JPP.%{name}-ecache-parent.pom
install -p -m 644 core/pom.xml \
    %{buildroot}%{_datadir}/maven2/poms/JPP-%{name}.pom
install -p -m 644 debugger/pom.xml \
    %{buildroot}%{_datadir}/maven2/poms/JPP-%{name}-debugger.pom

# javadoc
install -d -m 755 %{buildroot}%{_javadocdir}/%{name}-%{version}
#cp -pr target/site/apidocs/* %{buildroot}%{_javadocdir}/%{name}-%{version}
ln -s %{name}-%{version} %{buildroot}%{_javadocdir}/%{name}

install -d -m 755 %{buildroot}%{_docdir}/%{name}-%{version}
cp -p core/CHANGELOG.txt %{buildroot}%{_docdir}/%{name}-%{version}/
cp -p core/LICENSE.txt %{buildroot}%{_docdir}/%{name}-%{version}/
cp -p core/RELEASE_NOTES.txt %{buildroot}%{_docdir}/%{name}-%{version}/

%if 0
## manual
%if %with maven
cp -pr target/site %{buildroot}%{_docdir}/%{name}-%{version}
rm -r %{buildroot}%{_docdir}/%{name}-%{version}/apidocs
%endif
%endif

%if %{gcj_support}
%{_bindir}/aot-compile-rpm
%endif
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/hibernate_in_process_cache_ehcache<<EOF
%{_javadir}/hibernate_in_process_cache.jar	%{_javadir}/%{name}.jar	90
EOF

%files
%_altdir/hibernate_in_process_cache_ehcache
%doc %dir %{_docdir}/%{name}-%{version}
%doc %{_docdir}/%{name}-%{version}/CHANGELOG.txt
%doc %{_docdir}/%{name}-%{version}/LICENSE.txt
%doc %{_docdir}/%{name}-%{version}/RELEASE_NOTES.txt
%{_javadir}/%{name}-%{version}.jar
%{_javadir}/%{name}.jar
%{_javadir}/%{name}-debugger-%{version}.jar
%{_javadir}/%{name}-debugger.jar
%{_datadir}/maven2/poms/*
%{_mavendepmapfragdir}/*
%if %{gcj_support}
%dir %{_libdir}/gcj/%{name}
%{_libdir}/gcj/%{name}/%{name}-*%{version}.jar.*
%endif
# hack; explicitly added docdir if not owned
%doc %dir %{_docdir}/%{name}-%{version}

%if %with hibernate
%files hibernate
%{_javadir}/%{name}-hibernate-%{version}.jar
%{_javadir}/%{name}-hibernate.jar
%endif

%files javadoc
%{_javadocdir}/%{name}-%{version}
%{_javadocdir}/%{name}

%if 0
%if %with maven
%files manual
%dir %{_docdir}/%{name}-%{version}
%{_docdir}/%{name}-%{version}/site
%endif
%endif
# hack; explicitly added docdir if not owned
%doc %dir %{_docdir}/%{name}-%{version}

%changelog
