%def_disable tests
%def_disable static

Name: eina
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: Enlightenment Data Type Library
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.enlightenment.org/

# http://svn.enlightenment.org/svn/e/trunk/%name
Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2

%{?_enable_static:BuildPreReq: glibc-devel-static}
BuildRequires: gcc-c++ libcheck-devel lcov doxygen

%description
 Eina is a multi-platform library that provides optimized data types and a few
 tools. It supports the following data types:
 Containers:
  o Array: an array
  o Hash Table: a hash table
  o Inlined List: an list with functions inlined
  o List: a single-linked list
  o Red-Black Tree: a tree
  o Access Content types
    + Accessor: can access items of a container randomly
    + Iterator: can access items of a container sequentially.
 Stringshare.

%package -n lib%name
Summary: Enlightenment Data Type Library
Group: System/Libraries

%description -n lib%name
 Eina is a multi-platform library that provides optimized data types and a few
 tools. It supports the following data types:
 Containers:
  o Array: an array
  o Hash Table: a hash table
  o Inlined List: an list with functions inlined
  o List: a single-linked list
  o Red-Black Tree: a tree
  o Access Content types
    + Accessor: can access items of a container randomly
    + Iterator: can access items of a container sequentially
 Stringshare.

This package contains shared Eina library.

%package -n lib%name-devel
Summary: Enlightenment Data Type Library development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
 Eina is a multi-platform library that provides optimized data types and a few
 tools. It supports the following data types:
 Containers:
  o Array: an array
  o Hash Table: a hash table
  o Inlined List: an list with functions inlined
  o List: a single-linked list
  o Red-Black Tree: a tree
  o Access Content types
    + Accessor: can access items of a container randomly
    + Iterator: can access items of a container sequentially
 Stringshare.

This package contains headers, development libraries, test programs and
documentation for Eina

%prep
%setup -q -n %name-%version

%build
%configure \
	%{subst_enable static} \
	%{subst_enable tests}

%make_build
#%make doc

%install
%make DESTDIR=%buildroot install

%check
%{?_enable_tests:%make check}

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS README

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%changelog
