Name: eiskaltdcpp
Version: 2.2.8
Release: alt1
Summary: EiskaltDC++ - Direct Connect client
License: GPLv3
Group: Networking/File transfer
Url: http://code.google.com/p/eiskaltdc/
Packager: Aeliya Grevnyov <gray_graff@altlinux.org>

Source: %name-%version.tar
#Patch: eiskaltdcpp-2.2.5-alt-DSO.patch
#Patch1: eiskaltdcpp-2.2.7-alt-boost-1.52.0.patch

BuildRequires: cmake gcc-c++ libqt4-devel bzlib-devel libaspell-devel liblua5-devel
BuildRequires: libgtk+2-devel libglade-devel glib2-devel libpango-devel libnotify-devel 
BuildRequires: boost-devel boost-signals-devel boost-interprocess-devel
BuildRequires: phonon-devel libssl-devel libidn-devel libpcrecpp-devel
BuildRequires: aspell perl-JSON-RPC perl-Term-ShellUI

%add_findreq_skiplist *xmms2_audacious2.ru_RU.UTF-8.php
%add_findreq_skiplist *commands.ru_RU.UTF-8.php

%description
EiskaltDC++ is a cross-platform program that uses the Direct Connect and ADC protocol. 
It is compatible with other DC clients, such as the original DC from Neomodus, DC++ and derivatives. 
EiskaltDC++ also interoperates with all common DC hub software. 


%package common
Group: Networking/File transfer
Summary: Common files for %name
Requires: lib%name = %version-%release
BuildArch: noarch
%description common
Common files for %name

%package gtk
Group: Networking/File transfer
Summary: GTK-based graphical interface
Requires: %name-gtk-data = %version-%release
%description gtk
Gtk interface based on code of FreeDC++ and LinuxDC++

%package gtk-data
Group: Networking/File transfer
Summary: noarch files for GTK-based graphical interface
Requires: %name-common = %version-%release
BuildArch: noarch
%description gtk-data
noarch files for Gtk interface based on code of FreeDC++ and LinuxDC++

%package qt
Group: Networking/File transfer
Summary: Qt-based graphical interface
Provides: %name = %version-%release
Obsoletes: %name <= 2.0.3-alt1
Requires: %name-qt-data = %version-%release
%description qt
Qt-based graphical interface

%package qt-data
Group: Networking/File transfer
Summary: Qt-based graphical interface
Requires: %name-common = %version-%release
BuildArch: noarch
%description qt-data
noarch files for Qt-based graphical interface

%package -n lib%name
Group: System/Libraries
Summary: eiskaltdcpp libraries
Obsoletes: libdcpp
%description -n lib%name
eiskaltdcpp libraries

%package daemon
Group: Networking/File transfer
Summary: Daemon interface
Requires: %name-common = %version-%release
%description daemon
Daemon interface

%package cli
Group: Networking/File transfer
Summary: cli for Daemon
Requires: %name-daemon = %version-%release
%description cli
command line interface for XML-RPC Daemon

%prep
%setup
#%%patch -p2
#%%patch1 -p2

%build
%add_optflags -fno-strict-aliasing $(pkg-config libpcre --cflags)
mkdir -p BUILD
pushd BUILD
cmake .. \
 -DCMAKE_BUILD_TYPE=Release \
 -DCMAKE_SKIP_RPATH:BOOL=yes \
 -DCMAKE_C_FLAGS:STRING="%optflags" \
 -DCMAKE_CXX_FLAGS:STRING="%optflags" \
 -DCMAKE_INSTALL_PREFIX=%prefix \
 -DLIB_DESTINATION=%_lib \
%if %_lib == lib64
 -DLIBDIR=lib64 \
%endif
 -DUSE_ASPELL=ON \
 -DUSE_QT=ON \
 -DUSE_QT_QML=ON \
 -DFREE_SPACE_BAR_C=ON \
 -DUSE_MINIUPNP=ON \
 -DLOCAL_MINIUPNP=ON \
 -DUSE_GTK=ON \
 -DDBUS_NOTIFY=ON \
 -DUSE_JS=ON \
 -DLUA_SCRIPT=ON \
 -DWITH_LUASCRIPTS=ON \
 -DWITH_SOUNDS=ON \
 -DUSE_QT_SQLITE=ON \
 -DNO_UI_DAEMON=ON \
 -DJSONRPC_DAEMON=ON \
 -DUSE_CLI_JSONRPC=ON \
 -DPCRE_INCLUDE_DIR=$(pkg-config libpcre --variable=includedir) \
 -DPERL_REGEX=ON
popd
%make_build -C BUILD VERBOSE=1

%install
%makeinstall -C BUILD DESTDIR="%buildroot/"
%find_lang %name-gtk
%find_lang lib%name

%files qt
%_bindir/%name-qt

%files qt-data
%_desktopdir/%name-qt.desktop
%_datadir/%name/qt
%_man1dir/%name-qt*

%files gtk
%_bindir/%name-gtk

%files gtk-data -f %name-gtk.lang
%_desktopdir/%name-gtk.desktop
%_datadir/%name/gtk
%_man1dir/%name-gtk*

%files -n lib%name -f lib%name.lang
%_libdir/lib%name.so.*

%files common
%_datadir/%name/emoticons
%_datadir/%name/examples
%_datadir/%name/sounds
%_datadir/%name/update_geoip
%_datadir/%name/luascripts
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/64x64/apps/%name.png
%_iconsdir/hicolor/24x24/apps/%name.png
%_iconsdir/hicolor/22x22/apps/%name.png
%_pixmapsdir/*

%files daemon
%_bindir/%name-daemon
%_man1dir/%name-daemon*

%files cli
%_bindir/%name-cli-jsonrpc
%_man1dir/%name-cli*
%_datadir/%name/cli

%changelog
