%def_enable pam
%def_enable extra
%def_enable captcha
%def_disable hipe

Name: ejabberd
Version: 2.1.10
Release: alt1

Summary: Fault-tolerant distributed Jabber server written in Erlang
License: GPL2
Group: System/Servers
Url: http://www.process-one.net/en/ejabberd/

Requires: erlang >= R11B.5
Requires: jabber-common >= 0.2
Requires: su

BuildRequires(pre): jabber-common >= 0.2
BuildRequires: erlang-devel erlang-otp-devel libcom_err-devel libexpat-devel libssl-devel zlib-devel
%{?_enable_pam:BuildRequires: libpam-devel}

Source: %name-%version-%release.tar

%description
ejabberd is a Free and Open Source distributed fault-tolerant Jabber
server. It writen mostly in Erlang.

The main features of ejabberd is:

* Truly portable
* Distributed
* Fault-tolerance
* Built-in Multi-User Chat service
* Built-in IRC transport
* Built-in Publish-Subscribe service
* Built-in Jabber Users Directory service based on users vCards
* Built-in web-based administration interface
* Built-in HTTP Polling service
* SSL support
* Support for LDAP authentification
* Ability to interface with external components (JIT, MSN-t, Yahoo-t, etc)
* Migration from jabberd14 is possible
* Mostly XMPP-compliant
* Support for JEP-0030 (Service Discovery).
* Support for JEP-0039 (Statistics Gathering).
* Support for xml:lang 

%if_enabled captcha
%package captcha
Summary: captcha script for ejabberd
Group: System/Servers
Requires: %name = %version-%release
Requires: ImageMagick-tools

%description captcha
This package contains a shell script for creating captcha files.
%endif


%if_enabled pam
%package pam
Summary: PAM auth support for jabberd
Group: System/Servers
Requires: %name = %version-%release

%description pam
This package contains a privileged helper employed by %name
to perform PAM authentication of local users as jabber users.

No user-side registration is then possible, and plaintext auth
isn't accepted (basically you want to configure SSL).
%endif

%if_enabled extra
%package extra
Summary: Additional modules for ejabberd
Group: System/Servers
Requires: %name = %version-%release

%description extra
This package contains a set of optional modules that extend ejabberd functionality.
Currently there are: mod_asterisk and mod_rest.
%endif

%prep
%setup

%build
cd src
%configure --enable-odbc %{subst_enable pam} %{subst_enable hipe}
#--enable-user=ejabberd
# SMP-unaware
make

%install
%makeinstall -C src DESTDIR=%buildroot
(cd altlinux && find . -type f |cpio -pumd %buildroot)
grep -A1 -B1 '^%%%%%% ' src/mod_passrecover.erl >mod_passrecover.txt
mkdir -p %buildroot%_localstatedir/ejabberd %buildroot%_logdir/ejabberd \
	%buildroot%_sysconfdir/sysconfig/ %buildroot%_lockdir/ejabberd
mv %buildroot%_sysconfdir/%name/ejabberdctl.cfg %buildroot%_sysconfdir/sysconfig/ejabberd

mkdir -p %buildroot%_datadir/doc
ln -s %name-%version %buildroot%_datadir/doc/%name

%pre
%_sbindir/groupadd -r -f ejabberd &>/dev/null
%_sbindir/useradd -r -g ejabberd  -d %_localstatedir/ejabberd -s /dev/null \
    -c 'ejabberd server' -M -n ejabberd &>/dev/null ||:

%post
%post_service %name
%_jabber_config

%preun
%preun_service %name

%files
%doc COPYING README doc/* examples src/odbc/*.sql mod_passrecover.txt
%_datadir/doc/%name

%dir %_sysconfdir/ejabberd
%config(noreplace) %_sysconfdir/ejabberd/inetrc
%attr(640,root,ejabberd) %config(noreplace) %_sysconfdir/ejabberd/ejabberd.cfg
%attr(0640,root,ejabberd) %config(noreplace) %_sysconfdir/sysconfig/ejabberd
%attr(0640,root,root) %config %_sysconfdir/logrotate.d/ejabberd

%_initdir/ejabberd
%attr(0755,root,ejabberd) %_sbindir/ejabberdctl

%_libdir/ejabberd

%_jabber_server_dir/ejabberd

%_man8dir/*

%dir %_lockdir/%name

%attr(1770,root,ejabberd) %dir %_localstatedir/ejabberd
%attr(1770,root,ejabberd) %dir %_logdir/ejabberd
%attr(1770,root,ejabberd) %dir %_lockdir/ejabberd

%exclude %_sysconfdir/pam.d/ejabberd
%exclude %_libdir/ejabberd/priv/bin/captcha.sh

%if_enabled pam
%exclude %_libdir/ejabberd/ebin/epam.beam
%exclude %_libdir/ejabberd/priv/bin/epam
%endif

%if_enabled extra
%exclude %_libdir/ejabberd/ebin/mod_asterisk.beam
%exclude %_libdir/ejabberd/ebin/mod_rest.beam
%endif

%if_enabled captcha
%files captcha
%attr(4710,root,ejabberd) %_libdir/ejabberd/priv/bin/captcha.sh
%endif

%if_enabled pam
%files pam
%_sysconfdir/pam.d/ejabberd
%_libdir/ejabberd/ebin/epam.beam
%attr(4710,root,ejabberd) %_libdir/ejabberd/priv/bin/epam
%endif

%if_enabled extra
%files extra
%_libdir/ejabberd/ebin/mod_asterisk.beam
%_libdir/ejabberd/ebin/mod_rest.beam
%endif

%changelog
