%define ejudge_user ejudge
%define ejudge_group judges
%define ejudge_home /var/lib/ejudge
%define cgi_bin_dir /var/www/cgi-bin
%define httpd_htdocs_dir /var/www/html
%define ejudge_socket_dir /var/run/ejudge
%define lang_config_dir %{_sysconfdir}/ejudge/lang.d

%def_enable systemd
%brp_strip_none %_libexecdir/ejudge/bin/*
%brp_strip_none %_libexecdir/ejudge/*
%add_findreq_skiplist *vg*.in

Name: ejudge
Version: 3.3.1
Release: alt0.M70P.1

Summary: Ejudge is a programming contest managment system
Summary(ru_RU.UTF-8): Ejudge это система для проведения соревнований по программированию

License: GPL
Group: System/Servers
Url: http://www.ejudge.ru
Packager: Denis Kirienko <dk@altlinux.ru>

Source0: ejudge-20150607.tar
Source1: %name.rc
Source2: %name.logrotate
Source4: ejudge-README-ALT.utf8
Source5: ejudge-cntsguide.pdf
Source6: ejudge-refmanual.pdf
Source7: %name.service
Source8: %name.conf

Patch1: ejudge-stylecheck.patch
Patch2: ejudge-tsc.c.patch
Patch3: ejudge-compilers.patch

BuildPreReq: gcc-c++, flex, sed, mktemp, libexpat-devel, zlib-devel, libzip-devel, libncursesw-devel, libmysqlclient-devel, libcurl-devel, autoconf, libuuid-devel, libelf-devel
%if_enabled systemd
BuildRequires: systemd
%endif
Requires: sharutils, apache2, iconv, gawk, a2ps, mysql-server

Obsoletes: libreuse

%description
Ejudge is a programming contest managment system.

You must configure ejudge before running it.
Please read ejudge-README-ALT.utf8 for defails.

%description -l ru_RU.UTF-8
Ejudge - это система для организации соревнований по программированию.
Она позволяет участникам соревнований сдавать решения предлагаемых
задач, которые проверяются на заранее подготовленных тестах.
Также ejudge позволяет проводить тестирования на различных видах
задач: с выбором ответа, с кратким или развернутым ответом

Ejudge требует аккуратной настройки перед использованием.
Ссылка на инструкции по настройке в файле ejudge-README-ALT.utf8

%package doc
Summary: Documentation for ejudge
Summary(ru_RU.UTF-8): Документация для системы ejudge
Group: System/Servers
Requires: %name = %version-%release
BuildArch: noarch

%description doc
User and contest administratoxr manual for ejudge system.

%description doc -l ru_RU.UTF-8
Документация пользователя и администратора для системы
проведения соревновний по программированию ejudge.

%prep
%setup -q -n ejudge

%patch1 -p1
%patch2 -p1
%patch3 -p1
# %patch4 -p1
cp  %SOURCE4 %SOURCE5 %SOURCE6 .
sed -i "s/,-rpath,/,/" configure

%build
cd libdwarf
%configure
%make_build
cd ..
%configure                                                                \
--enable-charset=utf-8                                                    \
--enable-socket-path=%ejudge_socket_dir/userlist-socket                   \
--enable-super-serve-socket=%ejudge_socket_dir/super-serve-socket         \
--enable-new-server-socket=%ejudge_socket_dir/new-server-socket           \
--enable-contests-home-dir=%ejudge_home                                   \
--enable-local-dir=%ejudge_home/tmp                                       \
--libexec=%{_libexecdir}                                                  \
--enable-cgi-bin-dir=%{_libexecdir}/%name/cgi-bin                         \
--enable-conf-dir=%{ejudge_home}/data                                     \
--enable-cgi-conf-dir=../cgi-data                                         \
--enable-hidden-server-bins                                               \
--with-httpd-cgi-bin-dir=%cgi_bin_dir                                     \
--with-httpd-htdocs-dir=%httpd_htdocs_dir                                 \
--enable-ajax                                                             \
--enable-lang-config-dir=%lang_config_dir                                 \
--disable-rpath                                                           \
CPPFLAGS="-I%{_includedir}/libzip -I%{_libdir}/libzip/include"

%make_build RELEASE=1 CEXTRAFLAGS="-I%{_includedir}/libzip -I%{_libdir}/libzip/include -Wno-pointer-sign"

%install
%make_install DESTDIR=%buildroot install
install -p -m755 -D %SOURCE1 %buildroot%{_initdir}/%name
install -p -m644 -D %SOURCE2 %buildroot%{_logrotatedir}/%name
install -d %buildroot%ejudge_home
install -d %buildroot%ejudge_socket_dir
install -d %buildroot%lang_config_dir
%find_lang ejudge ejudgecheckers
cat ejudgecheckers.lang >> ejudge.lang

%if_enabled systemd
install -p -m644 -D %SOURCE7 %buildroot%{_unitdir}/%name.service
install -p -m644 -D %SOURCE8 %buildroot%{_tmpfilesdir}/%name.conf
%endif

%pre
%{_sbindir}/groupadd -r -f %ejudge_group 2>/dev/null || :
%{_sbindir}/useradd -g %ejudge_group -c 'Ejudge server' -d %ejudge_home -r %ejudge_user 2>/dev/null || :

%post
%post_service ejudge

%preun
%preun_service ejudge

%files -f %name.lang
%{_sysconfdir}/ejudge
%attr(2775,%ejudge_user,%ejudge_group) %dir %ejudge_home
%{_initdir}/%name
%{_logrotatedir}/%name
%{_bindir}/*
%{_includedir}/*
%{_libdir}/libchecker*
%{_libexecdir}/%name
%{_datadir}/%name
%attr(755,%ejudge_user,root) %dir %ejudge_socket_dir

%if_enabled systemd
%{_unitdir}/%name.service
%{_tmpfilesdir}/%name.conf
%endif

%doc AUTHORS ejudge-README-ALT.utf8

%files doc
%doc ejudge-*.pdf

%changelog
