
Name: ekiga
Version: 4.0.1
Release: alt2

Summary: IP phone client with full SIP and H.323 support

License: GPL
Group: Networking/Instant messaging
Url: http://www.ekiga.org

Provides: gnomemeeting
Obsoletes: gnomemeeting
Requires: libpt libopal libpt-plugins

# Source-git: git://git.gnome.org/ekiga
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define ptlib_ver 2.10.10
%define opal_ver 3.10.10

%def_enable gconf
%def_enable eds
%def_enable notify
%def_enable ldap
%def_enable xv
%def_enable dbus
%def_enable dbus_service
%def_enable avahi
%def_enable gstreamer
%def_enable xcap
%def_enable loudmouth
%def_enable gdu

BuildRequires: intltool gcc-c++
BuildRequires: pkgconfig(gtk+-2.0) >= 2.20.0 pkgconfig(gnome-icon-theme) >= 3.0.0
BuildRequires: pkgconfig(glib-2.0) >= 2.24.0 pkgconfig(gmodule-2.0) pkgconfig(gobject-2.0) pkgconfig(gthread-2.0)
BuildRequires: boost-signals-devel
BuildRequires: pkgconfig(libxml-2.0)
%{?_enable_gconf:BuildRequires: pkgconfig(gconf-2.0) >= 2.6.0}
%{?_enable_eds:BuildRequires: pkgconfig(libebook-1.2)}
%{?_enable_notify:BuildRequires: pkgconfig(libnotify)}
%{?_enable_ldap:BuildRequires: libldap-devel}
BuildRequires: libsasl2-devel
%{?_enable_xv:BuildRequires: pkgconfig(xv)}
%{?_enable_dbus:BuildRequires: pkgconfig(dbus-1) >= 0.36 pkgconfig(dbus-glib-1) >= 0.36}
BuildRequires: libv4l-devel
%{?_enable_avahi:BuildRequires: pkgconfig(avahi-client) >= 0.6 pkgconfig(avahi-glib) >= 0.6}
%{?_enable_gstreamer:BuildRequires: pkgconfig(gstreamer-plugins-base-0.10) >= 0.10.21.3 pkgconfig(gstreamer-interfaces-0.10) pkgconfig(gstreamer-app-0.10)}
%{?_enable_xcap:BuildRequires: pkgconfig(libsoup-2.4)}
%{?_enable_loudmouth:BuildRequires: pkgconfig(loudmouth-1.0)}
%{?_enable_gdu:BuildRequires: /usr/bin/scrollkeeper-config gnome-doc-utils}
BuildRequires: pkgconfig(ptlib) >= %ptlib_ver
BuildRequires: pkgconfig(opal) >= %opal_ver

%description
Ekiga is an IP phone client with full SIP and H.323 support.

%package plugin-avahi
Summary: Avahi(mDNS) Support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-avahi
Avahi(mDNS) Support for Ekiga.

%package plugin-evolution
Summary: Evolution-data-server addressbook support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-evolution
Evolution-data-server addressbook support for Ekiga.

%package plugin-gstreamer
Summary: GStreamer support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-gstreamer
GStreamer support for Ekiga.

%package plugin-ldap
Summary: LDAP addressbook support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-ldap
LDAP addressbook support for Ekiga.

%package plugin-notify
Summary: Libnotify support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-notify
libnotify support for Ekiga.

%package plugin-xmpp
Summary: Experimental Loudmouth support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-xmpp
experimental Loudmouth support for Ekiga.

%package plugin-xcap
Summary: experimental XCAP support for Ekiga
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description plugin-xcap
experimental XCAP support for Ekiga.

%package plugins
Summary: All plugins for Ekiga
Group: Networking/Instant messaging
%{?_enable_avahi:Requires: %name-plugin-avahi = %version-%release}
%{?_enable_eds:Requires: %name-plugin-evolution = %version-%release}
%{?_enable_gstreamer:Requires: %name-plugin-gstreamer = %version-%release}
%{?_enable_ldap:Requires: %name-plugin-ldap = %version-%release}
%{?_enable_notify:Requires: %name-plugin-notify = %version-%release}
%{?_enable_loudmouth:Requires: %name-plugin-xmpp = %version-%release}
%{?_enable_xcap:Requires: %name-plugin-xcap = %version-%release}

%description plugins
All for Ekiga.

%prep
%setup -q
%patch -p1

%build
gnome-doc-prepare -f
%autoreconf
%configure \
	--disable-schemas-install \
	--disable-scrollkeeper \
	%{subst_enable gconf} \
	%{subst_enable eds} \
	%{subst_enable notify} \
	%{subst_enable ldap} \
	%{subst_enable xv} \
	%{subst_enable dbus} \
	%{?_enable_dbus_service:--enable-dbus-service} \
	%{subst_enable avahi} \
	%{subst_enable gstreamer} \
	%{subst_enable xcap} \
	%{subst_enable loudmouth} \
	%{subst_enable gdu}

%make_build

%install
%makeinstall_std

%find_lang %name --with-gnome

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %name
fi

%files -f %name.lang
%doc README FAQ AUTHORS TODO
%_sysconfdir/gconf/schemas/*.schemas
%_bindir/%{name}*
%dir %_libdir/%name
%dir %_libdir/%name/%version
%_libdir/%name/%version/*.so
%dir %_libdir/%name/%version/plugins
%_datadir/dbus-1/services/*
%_datadir/sounds/%name
%_desktopdir/*.desktop
%_pixmapsdir/%name
%_iconsdir/hicolor/*/apps/%name.png
%_man1dir/*.1*

%exclude %_libdir/%name/%version/*.la
%exclude %_libdir/%name/%version/plugins/*.la


%if_enabled avahi
%files plugin-avahi
%_libdir/%name/%version/plugins/libgmavahi.so
%endif

%if_enabled eds
%files plugin-evolution
%_libdir/%name/%version/plugins/libgmevolution.so
%endif

%if_enabled gstreamer
%files plugin-gstreamer
%_libdir/%name/%version/plugins/libgmgstreamer.so
%endif

%if_enabled ldap
%files plugin-ldap
%_libdir/%name/%version/plugins/libgmldap.so
%endif

%if_enabled notify
%files plugin-notify
%_libdir/%name/%version/plugins/libgmlibnotify.so
%endif

%if_enabled loudmouth
%files plugin-xmpp
%_libdir/%name/%version/plugins/libgmloudmouth.so
%endif

%if_enabled xcap
%files plugin-xcap
%_libdir/%name/%version/plugins/libgmresource_list.so
%_libdir/%name/%version/plugins/libgmxcap.so
%endif

%files plugins

%changelog
