Name: elfutils
Version: 0.155
Release: alt2

Summary: A collection of utilities and DSOs to handle compiled objects
License: GPLv3+ and (GPLv2+ or LGPLv3+)
Group: Development/C
URL: http://fedorahosted.org/elfutils/

# http://fedorahosted.org/releases/e/l/elfutils/%version/%name-%version.tar.bz2
Source: %name-%version.tar

Patch1: elfutils-0.155-rh-portability.patch
Patch2: elfutils-0.155-rh-robustify.patch
Patch3: elfutils-0.155-rh-binutils-pr-ld-13621.patch
Patch4: elfutils-0.147-alt-findtextrel.patch
Patch5: elfutils-0.147-alt-osabi.patch
Patch6: elfutils-0.155-alt-elflint-bss.patch
Patch7: elfutils-0.155-alt-elflint-st_value.patch

Requires: libelf = %version-%release

%def_enable static
%def_disable check

BuildRequires: bzlib-devel flex liblzma-devel zlib-devel
%{?_enable_check:BuildRequires: /proc}

%define _gnu %nil
%define _configure_script ../configure
%define _programprefix eu-
%define buildtarget build-%_target_platform

%description
Elfutils is a collection of utilities, including ld (a linker), nm
(for listing symbols from object files), size (for listing the section
sizes of an object or archive file), strip (for discarding symbols),
readelf (to see the raw ELF file structures), and elflint (to check for
well-formed ELF files).  Also included are numerous helper libraries
which implement DWARF, ELF, and machine-specific ELF handling.

%package devel
Summary: Development libraries to handle compiled objects
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: %name = %version-%release
Requires: libelf-devel = %version-%release

%description devel
This package contains the libraries to create applications for
handling compiled objects.  libebl provides some higher-level ELF access
functionality.  libdw provides access to the DWARF debugging information.
libasm provides a programmable assembler interface.

%package -n libelf
Summary: Library to read and write ELF files
License: GPLv2+ or LGPLv3+
Group: System/Libraries

%description -n libelf
This package provides a DSO which allows reading and writing ELF files
on a high level.  Third party programs depend on this package to read
internals of ELF files.  The programs of the elfutils package use it
also to generate new ELF files.

%package -n libelf-devel
Summary: Development libelf library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf = %version-%release

%description -n libelf-devel
This package contains the library to create applications for handling
compiled objects.  libelf allows you to access the internals of the ELF
object file format, so you can see the different sections of an ELF file.

%package -n libelf-devel-static
Summary: Static libelf library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf-devel = %version-%release

%description -n libelf-devel-static
This package contains static library to create applications for handling
compiled objects.  libelf allows you to access the internals of the ELF
object file format, so you can see the different sections of an ELF file.

%prep
%setup
#patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

# Remove flex-generated files.
rm libcpu/i386_lex.c src/ldlex.c

# Disable -Werror for a while.
#sed -i 's/ -Werror / /' tests/Makefile*

bzip2 -9k NEWS
find -type f -name \*.sh -not -perm -0100 -print0 |
	xargs -r0 chmod +x --

%build
%add_optflags -fexceptions
rm -rf %buildtarget
mkdir %buildtarget
cd %buildtarget
%configure --enable-dependency-tracking \
	--program-prefix=%_programprefix \
	--enable-dwz \
	--enable-shared %{subst_enable static}
%make_build

%install
%makeinstall_std -C %buildtarget
%find_lang %name

%check
export PATH="%buildroot%_bindir:$PATH" LD_LIBRARY_PATH=%buildroot%_libdir
%make_build -k check -C %buildtarget

%files
%_bindir/eu-addr2line
%_bindir/eu-ar
%_bindir/eu-elfcmp
%_bindir/eu-elflint
%_bindir/eu-findtextrel
%_bindir/eu-make-debug-archive
%_bindir/eu-nm
%_bindir/eu-objdump
%_bindir/eu-ranlib
%_bindir/eu-readelf
%_bindir/eu-size
%_bindir/eu-strings
%_bindir/eu-strip
%_bindir/eu-unstrip
%exclude %_bindir/eu-ld
%_libdir/libasm-*.so
%_libdir/libdw-*.so
%_libdir/libasm*.so.*
%_libdir/libdw*.so.*
%_libdir/elfutils

%files devel
%_includedir/dwarf.h
%_includedir/elfutils
%_libdir/libasm.so
%_libdir/libdw.so
%exclude %_libdir/libasm.a
%exclude %_libdir/libdw.a
%exclude %_libdir/libebl.a

%files -n libelf -f %name.lang
%doc AUTHORS CONTRIBUTING NEWS.bz2 NOTES README THANKS
%_libdir/libelf-*.so
%_libdir/libelf*.so.*

%files -n libelf-devel
%_libdir/libelf.so
%_includedir/libelf.h
%_includedir/gelf.h
%_includedir/nlist.h

%if_enabled static
%files -n libelf-devel-static
%_libdir/libelf.a
%endif

%changelog
