# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: emacs-base.spec,v 1.10 2006/05/03 08:50:57 eugene Exp $

Name: emacs-base
Version: 0.0.7
Release: alt1

Group: Editors
Summary: Common site start scripts for GNU Emacs
License: GPL

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

BuildArch: noarch

Provides: %_sysconfdir/emacs/site-start.d
Provides: %_emacslispdir
Provides: %_datadir/emacs
Provides: %_datadir/emacs/etc
Provides: emacsen-startscripts
Obsoletes: emacsen-startscripts

Conflicts: rootfiles <= alt-alt4
# from now on xemacs has its own start-scripts
Conflicts: xemacs < 21.4.9
# pc-select.el is updated:
Conflicts: emacs-common < 21.3-alt6
Conflicts: emacs21-common < 21.3-alt6

# Mdk's and ALT's global config merged:
Source0: %name-ALT-%version.tar
Source1: %name.buildreq

%description
The common site start scripts for Emacsen contain the default
configuration for Emacsen suggetsted by ALT. It also implements a
mechanism for installing additional Emacs Lisp modules at the site
and making them visible for users. Administrators can add some scripts
of their own to customize Emacsen even more.

The start scripts are itnended to be excuted by GNU Emacs, so some
of them contain Emacsen specific parts (embraced by special macros).
This package is always installed if you install any of the Emacsen.

The idea of compatibility with XEmacs has been dropped, XEmacs has its own
configuration.

%prep
%setup -q -n emacs

%install
mkdir -p %buildroot%_sysconfdir/emacs/site-start.d
install -m 644 site-start.el %buildroot%_sysconfdir/emacs
install -m 644 site-start.d/* %buildroot%_sysconfdir/emacs/site-start.d

# Buildreq filter for emacs.
install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name

mkdir -p %buildroot%_emacslispdir
mkdir -p %buildroot%_datadir/emacs/etc

%files
%dir %_sysconfdir/emacs
%dir %_sysconfdir/emacs/site-start.d
%config(noreplace) %_sysconfdir/emacs/site-start.el
%config(noreplace) %_sysconfdir/emacs/site-start.d/*.el
%dir %_datadir/emacs
%dir %_datadir/emacs/etc
%dir %_emacslispdir

%config %_sysconfdir/buildreqs/files/ignore.d/*

%doc doc/inhibit-site-start.txt
%lang(ru) %doc doc/inhibit-site-start.ru.txt

# TODO:
# 1. Добавить check-shadows?

%changelog
