# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: emacs-muse-mode.spec,v 1.1 2006/05/27 12:58:42 eugene Exp $

%define modename muse
%define base_rel alt1

Version: 3.20
%ifdef beta_ver
Release: %base_rel.%beta_ver
%else
Release: %base_rel
%endif
Name: emacs-%modename-mode
License: GPL
Group: Editors
Url: http://www.mwolson.org/projects/MuseMode.html
Summary: Publishing environment for Emacs
Requires: emacs-common emacs-misc-modes

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

%ifdef beta_ver
Source: http://www.mwolson.org/static/dist/%modename/%modename-%version%beta_ver.tar.gz
%else
Source: http://www.mwolson.org/static/dist/%modename/%modename-%version.tar.gz
%endif
Source1: %name.el

BuildArch: noarch

BuildPreReq: emacs-misc-modes >= 0.2-alt3
BuildPreReq: emacs-devel

# Automatically added by buildreq on Sat May 27 2006
BuildRequires: fontconfig

%description
Emacs Muse is an authoring and publishing environment for Emacs. It
simplifies the process of writings documents and publishing them to various
output formats. Muse uses a very simple Wiki-like format as input.

Muse consists of two main parts: an enhanced text-mode for authoring
documents and navigating within Muse projects, and a set of publishing
styles for generating different kinds of output.

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: %name = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%prep
%ifdef beta_ver
%setup -q -n %modename-%version%beta_ver
%else
%setup -q -n %modename-%version
%endif

%build
%__make PREFIX=%prefix

%install
mkdir -p %buildroot%_emacslispdir/%modename
install -m 644 lisp/*.el* %buildroot%_emacslispdir/%modename

mkdir -p %buildroot%_infodir
install -m 644 texi/*.info* %buildroot%_infodir/

mkdir -p %buildroot%_emacs_sitestart_dir
install -m 644 %SOURCE1 %buildroot%_emacs_sitestart_dir/%modename.el

# gzip ChangeLog*

%files
%doc AUTHORS NEWS README
%_infodir/*
%dir %_emacslispdir/%modename
%_emacslispdir/%modename/*.elc
%_emacslispdir/%modename/%modename-autoloads.el
%config(noreplace) %_emacs_sitestart_dir/*

%files el
%_emacslispdir/%modename/*.el
%exclude %_emacslispdir/%modename/%modename-autoloads.el


%changelog
