%def_disable static

Name: embryo
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif

Summary: A small virtual machine engine (in a library) and bytecode compiler
License: BSD
Group: System/Libraries
URL: http://www.enlightenment.org/

Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2

BuildRequires: libeina-devel >= 1.7.7
%{?_enable_static:BuildPreReq: glibc-devel-static}
BuildRequires: doxygen

%description
Embryo is primarily a shared library that gives you an API to load and control
interpredted programs compiled into the abstract machine bytecode that it
understands. This abstrac (or virtual) machine is imilar to a real machin
with a CPU, but it is emulated in software. The architecture is simple and is
the same as the abstract machine (AMX) in the
http://www.compuphase.com/small.htm language as it is based
on exactly the same code. Embryo has modified the code for the AMX extensively
and has made it smaller and more portable. It is VERY small. The total size
of the virtual machine code AND header files is less than 2500 lines of code.
It includes the floating point library support by default as well. This makes
it one of the smallest interpreting engines around, and thus makes is very
efficient to use in code.

%package -n %{name}_cc
Summary: Embryo compiler
Group: Development/Other

%description -n %{name}_cc
Embryo is primarily a shared library that gives you an API to load and control
interpredted programs compiled into the abstract machine bytecode that it
understands. This abstrac (or virtual) machine is imilar to a real machin
with a CPU, but it is emulated in software. The architecture is simple and is
the same as the abstract machine (AMX) in the
http://www.compuphase.com/small.htm language as it is based
on exactly the same code. Embryo has modified the code for the AMX extensively
and has made it smaller and more portable. It is VERY small. The total size
of the virtual machine code AND header files is less than 2500 lines of code.
It includes the floating point library support by default as well. This makes
it one of the smallest interpreting engines around, and thus makes is very
efficient to use in code.

This package contains embryo compiler.

%package -n lib%name
Summary: embryo library
Group: System/Libraries

%description -n lib%name
Embryo is primarily a shared library that gives you an API to load and control
interpredted programs compiled into the abstract machine bytecode that it
understands. This abstrac (or virtual) machine is imilar to a real machin
with a CPU, but it is emulated in software. The architecture is simple and is
the same as the abstract machine (AMX) in the
http://www.compuphase.com/small.htm language as it is based
on exactly the same code. Embryo has modified the code for the AMX extensively
and has made it smaller and more portable. It is VERY small. The total size
of the virtual machine code AND header files is less than 2500 lines of code.
It includes the floating point library support by default as well. This makes
it one of the smallest interpreting engines around, and thus makes is very
efficient to use in code.

This package contains shared embryo library.

%package -n lib%name-devel
Summary: embryo headers and development libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Embryo is primarily a shared library that gives you an API to load and control
interpredted programs compiled into the abstract machine bytecode that it
understands. This abstrac (or virtual) machine is imilar to a real machin
with a CPU, but it is emulated in software. The architecture is simple and is
the same as the abstract machine (AMX) in the
http://www.compuphase.com/small.htm language as it is based
on exactly the same code. Embryo has modified the code for the AMX extensively
and has made it smaller and more portable. It is VERY small. The total size
of the virtual machine code AND header files is less than 2500 lines of code.
It includes the floating point library support by default as well. This makes
it one of the smallest interpreting engines around, and thus makes is very
efficient to use in code.

This package contains embryo headers and development libraries

%package -n lib%name-devel-static
Summary: embryo static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Embryo is primarily a shared library that gives you an API to load and control
interpredted programs compiled into the abstract machine bytecode that it
understands. This abstrac (or virtual) machine is imilar to a real machin
with a CPU, but it is emulated in software. The architecture is simple and is
the same as the abstract machine (AMX) in the
http://www.compuphase.com/small.htm language as it is based
on exactly the same code. Embryo has modified the code for the AMX extensively
and has made it smaller and more portable. It is VERY small. The total size
of the virtual machine code AND header files is less than 2500 lines of code.
It includes the floating point library support by default as well. This makes
it one of the smallest interpreting engines around, and thus makes is very
efficient to use in code.

This package contains static libraries

%prep
%ifdef beta
%setup -q -n %name-%version.%beta
%else
%setup -q
%endif

%build
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static}
%make_build
%make doc

%install
%make_install DESTDIR=%buildroot install

%files -n %{name}_cc
%_bindir/%{name}_cc

%files -n lib%name
%_libdir/*.so.*
%_datadir/%name
%doc AUTHORS COPYING INSTALL README

%files -n lib%name-devel
%_includedir/*
%_pkgconfigdir/*.pc
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
