Name: emdros
Version: 3.1.1
Release: alt1.2.qa1

Summary: The database engine for analyzed or annotated text
License: GPL
Group: Databases

Packager: Kirill Maslinsky <kirill@altlinux.org>
URL: http://emdros.org
Source: emdros-%version.tar
Patch0: emdros-%version-alt-locallib.patch
Patch1: emdros-3.1.1-alt-python.patch

BuildRequires(pre): rpm-build-python
# Automatically added by buildreq on Wed Sep 24 2008 (-bi)
BuildRequires: gcc-c++ libMySQL-devel libpango-devel libpcre-devel libsqlite3-devel postgresql-devel python-devel wxGTK-devel zlib-devel
# not added automatically by buildreq
BuildRequires: swig

Requires: lib%name = %version-%release, %name-gui = %version-%release, %name-utils = %version-%release, %name-doc = %version-%release

%description
Emdros is a text database engine for storage and retrieval of annotated
or analyzed text. Application domains include linguistics, publishing,
and text processing. Emdros has a powerful query-language for
query/create/update/delete operations.

%package -n lib%name
Summary: The database engine for analyzed or annotated text: shared libraries
Group: Databases

%description -n lib%name
Emdros is a text database engine for storage and retrieval of annotated
or analyzed text. Application domains include linguistics, publishing,
and text processing. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains shared librares used by emdros tools.

%package gui
Summary: The database engine for analyzed or anotated text: GUI programs
Group: Databases
Requires: %name-utils = %version-%release

%description gui
Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains end-user GUI-programs distributed with emdros:
tools for database creation amd querying.

%package utils
Summary: The database engine for analyzed or annotated text: utilities
Group: Databases

%description utils

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains various utils distributed with emdros: commandline
tools for database creation amd querying, utils for importing data from popular
linguistic annotation formats.

%package doc
Summary: The database engine for analyzed or annotated text: documentation
Group: Databases
BuildArch: noarch

%description doc

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains emdros documentation.

%package -n lib%name-devel
Summary: The database engine for analyzed or annotated text: development files
Group: Development/Databases
Provides: emdros-devel = %version-%release
Obsoletes: emdros-devel <= 3.0.0-alt1

%description -n lib%name-devel

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains the development files needed for building
applications with Emdros.

%package -n python-module-EmdrosPy
Summary: The database engine for analyzed or annotated text: python interface
Group: Development/Python

%description -n python-module-EmdrosPy

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains python interface to EMdF and MQL.

%prep
%setup -q -n emdros-%version
rm -rv pcre sqlite sqlite3
%patch0 -p2
%patch1 -p2
sed -i 's,-lpython2.5,-lpython%_python_version,' SWIG/python/Makefile.am

%build
autoreconf -fisv
export lt_prog_compiler_static_works=no
%configure --with-swig-language-python=yes --with-swig-language-perl=no --with-swig-language-ruby=no \
--disable-debug --with-sqlite3=system --with-sqlite=no --with-default-backend=sqlite3 --enable-utf8 --disable-static
%make_build
bzip2 ChangeLog

%install
%make_install install DESTDIR=%buildroot
mkdir -p %buildroot/%python_sitelibdir/
mv %buildroot/%_libdir/%name/* %buildroot/%python_sitelibdir/

for i in wx/*.png ; do \
	size=$(basename "${i##*blue-E-}" .png) ; \
	install -D "$i" %buildroot/%_iconsdir/hicolor/$size/apps/emergence-blue-E.png ; \
	done
mkdir -p %buildroot%_desktopdir
find -name "*.desktop" -exec sed -i '/Encoding/d' {} \;
find -name "*.desktop" -exec cp -t %buildroot%_desktopdir {} \;

%check
tests/emdftry -b SQLite3
tests/mqltry -b SQLite3
tests/mqllingtry -b SQLite3

%files

%files -n lib%name
%_libdir/*.so.*
%exclude %_libdir/libemdrosguiu*.so.*

%files -n lib%name-devel
%_includedir/emdros/
%_libdir/*.so

%files gui
%_bindir/chunkingtoolu
%_bindir/eqtu
%_bindir/htmlcanvastestu
%_bindir/htreetestu
%_bindir/importtoolu
%_man1dir/eqtu.1.gz
%_libdir/libemdrosguiu*.so.*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%files utils
%doc AUTHORS COPYING NEWS README ChangeLog.bz2 INSTALL
%_bindir/TECkit_Compile
%_bindir/TxtConv
%_bindir/agexport
%_bindir/emdftry
%_bindir/eqtc
%_bindir/hal_build_db
%_bindir/manage_indices
%_bindir/mql
%_bindir/mqldump
%_bindir/mqlhal
%_bindir/mqllingtry
%_bindir/mqltry
%_bindir/negraimport
%_bindir/pennimport
%_bindir/plaintextimport
%_bindir/sfmimport
%_bindir/slashedtextimport
%_bindir/tigerxmlimport
%_bindir/ubimport
%_bindir/upgrade_db
%_bindir/jsontry
%_bindir/renderobjects
%_man1dir/agexport.1.gz
%_man1dir/emdftry.1.gz
%_man1dir/emdros.1.gz
%_man1dir/eqt.1.gz
%_man1dir/eqtc.1.gz
%_man1dir/hal_build_db.1.gz
%_man1dir/manage_indices.1.gz
%_man1dir/mql.1.gz
%_man1dir/mqldump.1.gz
%_man1dir/mqlhal.1.gz
%_man1dir/mqllingtry.1.gz
%_man1dir/mqltry.1.gz
%_man1dir/negraimport.1.gz
%_man1dir/pennimport.1.gz
%_man1dir/plaintextimport.1.gz
%_man1dir/sfmimport.1.gz
%_man1dir/slashedtextimport.1.gz
%_man1dir/tigerxmlimport.1.gz
%_man1dir/ubimport.1.gz
%_man1dir/upgrade_db.1.gz
%_man1dir/jsontry.1.gz
%_man1dir/renderobjects.1.gz
%_datadir/emdros/
%exclude %_datadir/emdros/*.png

%files doc
%doc doc/*
%doc examples/ChunkingTool/doc/ChunkingToolGuide.pdf
%doc src/qrytool/doc/EQTUsersGuide.pdf
%doc doc/progref/EmdrosProgRefGuide.pdf
%doc examples/HAL/doc/HALGuide.pdf
%doc src/importtool/doc/ImportToolUsersGuide.pdf
%doc SWIG/java/README-Java
%doc SWIG/java/TestEmdros.java
%doc SWIG/ruby/README-Ruby
%doc SWIG/ruby/test.rb
%doc SWIG/ruby/dir.sh
%doc SWIG/perl/README-Perl
%doc SWIG/perl/test.pl

%files -n python-module-EmdrosPy
%python_sitelibdir/*
%doc SWIG/python/README-Python
%doc SWIG/python/test.py
%doc SWIG/python/dir.py

%changelog
