%define ver_major 3.8
%def_disable static
%def_enable sendto
%def_enable map
%def_enable goa
%if_enabled goa
%define mcp_dir %(pkg-config --variable=plugindir mission-control-plugins)
%endif
%def_disable geocode
%def_enable gudev
%def_with cheese
%define gst_api_ver 1.0
%def_enable gst_1

Name: empathy
Version: %ver_major.6
Release: alt0.M70P.1

Summary: Instant Messaging Client for GNOME
License: GPL/LGPL
Group: Networking/Instant messaging
Url: https://live.gnome.org/Empathy

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar

Conflicts: telepathy-haze-aim
Obsoletes: libempathy libempathy-gtk python-module-empathy

Requires: %name-data = %version-%release

%define intltool_ver 0.35.0
%define glib_ver 2.33.3
%define gtk_ver 3.5.1
%define clutter_ver 1.1.2
%define clutter_gst_ver 1.9.92
%define tp_glib_ver 0.19.9
%define tp_logger_ver 0.8.0
%define tp_gabble_ver 0.16.0
%define tp_haze_ver 0.6.0
%define tp_salut_ver 0.8.0
%define mission_control_ver 5.13.0
%define enchant_ver 1.2.0
%define check_ver 0.9.4
%define iso_codes_ver 0.35
%define notify_ver 0.7.3
%define canberra_ver 0.26
%define webkit_ver 1.3.13
%define geoclue_ver 0.12
%define gcr_ver 3.3.90
%define champlain_ver 0.12.0
%define gnutls_ver 2.8.5
%define folks_ver 0.9.1
%define nst_ver 2.91.6
%define nm_ver 0.8.995
%define goa_ver 3.6.2
%define secret_ver 0.5
%define farstream_ver 0.2
%define geocode_ver 0.99.1

Requires: telepathy-gabble >= %tp_gabble_ver
Requires: telepathy-salut >= %tp_salut_ver
Requires: telepathy-haze >= %tp_haze_ver
Requires: libtelepathy-mission-control >= %mission_control_ver
Requires: telepathy-logger >= %tp_logger_ver
Requires: farstream0.2 >= %farstream_ver

BuildPreReq: intltool >= %intltool_ver gnome-common itstool
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libclutter-gtk3-devel >= %clutter_ver
BuildPreReq: libclutter-gst2.0-devel >= %clutter_gst_ver
BuildPreReq: libtelepathy-glib-devel >= %tp_glib_ver
BuildPreReq: libfolks-devel >= %folks_ver
BuildPreReq: libenchant-devel >= %enchant_ver
BuildPreReq: libcheck-devel >= %check_ver
BuildPreReq: iso-codes-devel >= %iso_codes_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildPreReq: libcanberra-gtk3-devel >= %canberra_ver
BuildPreReq: libgeoclue-devel >= %geoclue_ver
BuildPreReq: libwebkitgtk3-devel >= %webkit_ver
BuildPreReq: libsecret-devel >= %secret_ver
BuildPreReq: gcr-libs-devel >= %gcr_ver
BuildPreReq: libtelepathy-logger-devel >= %tp_logger_ver
BuildPreReq: libgnutls-devel >= %gnutls_ver
BuildRequires: libgee0.8-devel
# for gnome-control-center-3.0.x
# BuildPreReq: gnome-control-center-devel
BuildPreReq: NetworkManager-glib-devel >= %nm_ver libtelepathy-farstream-devel >= %farstream_ver
%{?_enable_sendto:BuildRequires: nautilus-sendto-devel >= %nst_ver}
%{?_enable_map:BuildPreReq: libchamplain-devel >= %champlain_ver  libchamplain-gtk3-devel >= %champlain_ver}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver libtelepathy-mission-control-devel}
%{?_enable_geocode:BuildRequires: libgeocode-glib-devel >= %geocode_ver}
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_with_cheese:BuildRequires: libcheese-devel}
BuildRequires: libcheck-devel gsettings-desktop-schemas-devel xsltproc
BuildRequires: yelp-tools itstool
BuildRequires: libpulseaudio-devel gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: db2latex-xsl evolution-data-server-devel gtk-doc
BuildRequires: xorg-cf-files libICE-devel libSM-devel
# for check
BuildRequires: xvfb-run

%description
Telepathy-based multi-protocol instant messaging client for GNOME
which supports Jabber, GTalk, MSN, IRC, Salut, and other protocols.

%package data
Summary: Arch independent files for Empathy
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for Empathy to work.

%package -n nautilus-sendto-empathy
Summary: Send files from nautilus to Empathy
Group: Graphical desktop/GNOME
Requires: nautilus-sendto >= 2.28.2
Requires: %name = %version-%release
Provides: nautilus-sendto-plugin = %version-%release

%description -n nautilus-sendto-empathy
This application provides integration between nautilus and Empathy.

%prep
%setup -q

rm -f data/%name.desktop

%build
#NOCONFIGURE=1 ./autogen.sh
%configure \
	--disable-schemas-compile \
	%{subst_enable static} \
	%{?_enable_goa:--enable-goa=yes} \
	%{?_enable_geocode:--enable-geocode=yes} \
	%{?_enable_gudev:--enable-gudev=yes} \
	%{subst_with cheese} \
	%{?_enable_sendto:--enable-nautilus-sendto=yes} \
	%{?_disable_sendto:--enable-nautilus-sendto=no} \
	%{?_enable_gst_1:--enable-gst-1.0}

# SMP-incompatible build
%make

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%check
# empathy-parser-test failed
# xvfb-run %make check


%files
%_bindir/*
%_libexecdir/empathy-auth-client
%_libexecdir/empathy-call
%_libexecdir/empathy-chat
%dir %_libdir/%name
%_libdir/%name/lib%name-%version.so
%_libdir/%name/lib%name.so
%_libdir/%name/lib%name-gtk-%version.so
%_libdir/%name/lib%name-gtk.so
%exclude %_libdir/%name/*.la
%if_enabled goa
%mcp_dir/mcp-account-manager-goa.so
%exclude %mcp_dir/mcp-account-manager-goa.la
%endif

%files data -f %name.lang
%_datadir/applications/%name.desktop
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Chat.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Call.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.Auth.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Empathy.FileTransfer.service
%dir %_datadir/%name
%_datadir/%name/*.ui
%_datadir/%name/*.dtd
%_datadir/%name/irc-networks.xml
%_datadir/%name/Template.html
%_datadir/%name/%name.css
%_datadir/telepathy/clients/Empathy.Chat.client
%_datadir/telepathy/clients/Empathy.Call.client
%_datadir/telepathy/clients/Empathy.Auth.client
%_datadir/telepathy/clients/Empathy.FileTransfer.client
%_datadir/%name/icons/
%_datadir/%name/%name-log-window.html
%_datadir/icons/hicolor/*/apps/*
%dir %_datadir/adium
%_datadir/adium/*
%_man1dir/*
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%doc AUTHORS CONTRIBUTORS NEWS README TODO

%if_enabled sendto
%files -n nautilus-sendto-%name
%_libdir/nautilus-sendto/plugins/libnst%name.so
%exclude %_libdir/nautilus-sendto/plugins/libnst%name.la
%endif


%changelog
