%define vtk_ver 5.10

Name: engrid
Version: 1.4
Release: alt3.git20120704.1
Summary: Mesh generation software with CFD applications in mind
License: GPL v3 or later
Group: Sciences/Physics
Url: http://sourceforge.net/projects/engrid/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://engrid.git.sourceforge.net/gitroot/engrid/engrid
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildPreReq: libvtk-devel libcgns-mpi-devel
BuildPreReq: libqt4-devel gcc-c++ libnetgen-devel
BuildPreReq: python-tools-2to3

%add_python3_req_skip BPyAddMesh bpy_extras mathutils
%add_python3_path %_datadir/blender/scripts/blender

%description
ENGRID is a mesh generation software with CFD applications in mind. It
supports automatic prismatic boundary layer grids for Navier-Stokes
simulations and has a Qt based GUI.

%package docs
Summary: Documentation for ENGRID
Group: Documentation
BuildArch: noarch

%description docs
ENGRID is a mesh generation software with CFD applications in mind. It
supports automatic prismatic boundary layer grids for Navier-Stokes
simulations and has a Qt based GUI.

This package contains documentation for ENGRID.

%prep
%setup

for i in $(find ./ -name '*.py'); do
	2to3 -w $i
done

%build
pushd src

%add_optflags -I%_includedir/vtk-%vtk_ver
qmake-qt4 QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" engrid.pro
%make_build

popd

%install
#makeinstall_std -C src INSTALL_ROOT=%buildroot

install -d %buildroot%_bindir
install -m755 src/%name %buildroot%_bindir

install -d %buildroot%_libdir
cp -P src/libengrid/libengrid.so.* %buildroot%_libdir/

install -d %buildroot%_man1dir
install -p -m644 debian/%name.1 %buildroot%_man1dir

install -d %buildroot%_niconsdir
install -d %buildroot%_miconsdir
install -d %buildroot%_liconsdir
install -p -m644 src/libengrid/resources/icons/engrid.xpm \
	%buildroot%_niconsdir
ln -s %_niconsdir/engrid.xpm %buildroot%_miconsdir/
ln -s %_niconsdir/engrid.xpm %buildroot%_liconsdir/

install -d %buildroot%_desktopdir
install -p -m644 debian/%name.desktop %buildroot%_desktopdir
install -d %buildroot%_datadir/blender/scripts/blender
install -p -m644 src/blender_scripts/2.4/* src/blender_scripts/2.63a/* \
	%buildroot%_datadir/blender/scripts/blender

%files
%doc *.txt
%_bindir/*
%_libdir/*.so.*
%_man1dir/*
%_niconsdir/*
%_miconsdir/*
%_liconsdir/*
%_desktopdir/*
%_datadir/blender/scripts/blender/*

%files docs
%doc manual tutorials

%changelog
