%define ver_major 3.8
%define api_ver %ver_major
%define ua_ver %ver_major

%def_with webkit2
%if_with webkit2
%def_disable introspection
%else
%def_enable introspection
%endif

Name: epiphany
Version: %ver_major.2
Release: alt1

Summary: Epiphany is a GNOME web browser.
Summary(ru_RU.UTF-8): Epiphany - интернет-браузер для графической оболочки GNOME.
Group: Networking/WWW
License: GPL
URL: http://www.gnome.org/projects/%name

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar

Provides: webclient
Obsoletes: %name-extensions

%define webkit_ver 1.11.92

Requires: %name-data = %version-%release indexhtml iso-codes
Requires: libwebkitgtk3-webinspector

BuildRequires: gnome-common
BuildPreReq: intltool >= 0.50.0
BuildPreReq: libgio-devel >= 2.35.6
BuildPreReq: libgtk+3-devel >= 3.5.2
BuildPreReq: libSM-devel
BuildPreReq: libxml2-devel >= 2.6.12
BuildPreReq: libxslt-devel >= 1.1.7
# Epiphany partially ported to WebKit2
BuildPreReq: libwebkitgtk3-devel >= %webkit_ver
%{?_with_webkit2:BuildPreReq: libwebkit2gtk-devel >= %webkit_ver}
BuildPreReq: libsoup-gnome-devel >= 2.41.3
BuildPreReq: libsecret-devel
BuildPreReq: gcr-libs-devel >= 3.5.5
BuildRequires: libwnck3-devel libgnome-desktop3-devel libnotify-devel libnss-devel libsqlite3-devel
# Zeroconf support
BuildPreReq: libavahi-devel libavahi-gobject-devel
# GObject introspection support
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libwebkitgtk3-gir-devel}
BuildPreReq: iso-codes-devel >= 0.35
BuildRequires: gcc-c++ gsettings-desktop-schemas-devel

%description
Epiphany is a GNOME web browser based on the Webkit rendering engine.
%description -l ru_RU.UTF8
Epiphany - интернет-браузер для графической
оболочки GNOME, основанный на движке
отрисовки страниц Webkit.

%package data
Summary: Epiphany data files
Group: Networking/WWW
BuildArch: noarch

%description data
Epiphany is a GNOME web browser based on the Webkit rendering engine.
This package contains common noarch files needed for Epiphany.

%package gir
Summary: GObject introspection data for the Epiphany
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Epiphany

%package gir-devel
Summary: GObject introspection devel data for the Epiphany
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Epiphany

%prep
%setup

[ ! -d m4 ] && mkdir m4

# sinc 3.7.92 --with-webkit2 flag removed
%{?_without_webkit2:subst 's/with_webkit2=yes/with_webkit2=no/' configure.ac}

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	--disable-dependency-tracking \
	%{?_enable introspection:--enable-introspection=yes} \
	--with-distributor-name="ALTLinux"

%make_build

%install
%make_install install DESTDIR=%buildroot

%__mkdir_p %buildroot{%_libdir/epiphany/%ua_ver/extensions,%_datadir/epiphany-extensions}

%find_lang --with-gnome --output=%name.lang %name %name-2.0

%files
%_bindir/*
%dir %_libdir/%name/%ua_ver/extensions
%dir %_libdir/%name/%ua_ver/web-extensions
%_libdir/%name/%ua_ver/web-extensions/libephywebextension.so
%exclude %_libdir/%name/%ua_ver/web-extensions/libephywebextension.la
%doc AUTHORS NEWS README TODO

%files data -f %name.lang
%_datadir/applications/*
%_datadir/%name
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/org.gnome.epiphany.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.enums.xml
%_datadir/GConf/gsettings/epiphany.convert
%_man1dir/*

%if_enabled introspection
%files gir
%_typelibdir/Epiphany-%ver_major.typelib

%files gir-devel
%_girdir/Epiphany-%ver_major.gir
%endif

%changelog
