%define ver_major 0.2
%def_enable alsa
%def_enable oss
%def_disable arts
%def_disable static

Name: esound
Version: %ver_major.41
Release: alt7

Summary: The Enlightened Sound Daemon
License: GPL
Group: System/Servers
Url: ftp://ftp.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.bz2
Patch1: %name-0.2.37-alt-config.patch
Patch3: %name-0.2.37-alt-esd_spawn_options.patch
Patch4: esound-0.2.37-alt-esd_no_spawn.patch
Patch7: %name-0.2.39-alt-shut_up.patch
Patch8: %name-0.2.41-link.patch

%define audiofile_ver 0.2.3

BuildPreReq: libaudiofile-devel >= %audiofile_ver
BuildRequires: docbook-utils-print libwrap-devel

%if_enabled alsa
%define alsa_ver 1.0.0
BuildPreReq: libalsa-devel >= %alsa_ver
%endif
%if_enabled arts
BuildPreReq: libarts-devel
%endif
%if_enabled static
BuildPreReq: glibc-static-devel
%endif

%description
EsounD (the Enlightened Sound Daemon) is a server process that allows multiple
applications to share a single sound card. For example, when you're listening
to music from your CD and you receive a sound-related event from ICQ, your
applications won't have to jockey for the attention of your sound card.

EsounD mixes several audio streams for playback by a single audio device.

%package -n esd
Summary: The Enlightened Sound Daemon
Group: System/Servers
Provides: esound = %version
Obsoletes: esound < %version
Provides: esound-daemon
Requires: libesd = %version-%release

%description -n esd
EsounD (the Enlightened Sound Daemon) is a server process that allows multiple
applications to share a single sound card. For example, when you're listening
to music from your CD and you receive a sound-related event from ICQ, your
applications won't have to jockey for the attention of your sound card.

EsounD mixes several audio streams for playback by a single audio device.

%package -n libesd
Summary: Enlightened Sound Daemon shared library
Group: System/Libraries

%description -n libesd
EsounD (the Enlightened Sound Daemon) is a server process that allows multiple
applications to share a single sound card. For example, when you're listening
to music from your CD and you receive a sound-related event from ICQ, your
applications won't have to jockey for the attention of your sound card.
EsounD mixes several audio streams for playback by a single audio device.

This package contains shared library for applications which use Esound.

%package utils
Summary: Enlightened Sound Daemon - clients
Group: Sound
Requires: libesd = %version-%release

%description utils
Utilities that control and interact with the Enlightened Sound Daemon.

%package -n libesd-devel
Summary: Libraries, includes and more to develop EsounD applications
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel < %version
Requires: libesd = %version-%release

%description -n libesd-devel
Libraries, include files and other resources you can use to develop EsounD
applications.

%package -n libesd-devel-static
Summary: Static libraries to develop EsounD applications
Group: Development/C
Provides: %name-devel-static = %version
Obsoletes: %name-devel-static < %version
Requires: libesd-devel = %version-%release

%description -n libesd-devel-static
Static libraries you can use to develop statically linked EsounD
applications.

%prep
%setup -q
%patch1 -p1
%patch3 -p1
%patch4 -p1
%patch7
%patch8

%build
%autoreconf
%configure \
	--with-libwrap \
	--enable-local-sound \
	%{subst_enable alsa} \
	%{subst_enable oss} \
	%{subst_enable arts} \
	%{subst_enable static}

%make_build

%install
# fix manpage for esd
subst 's,/etc/esound,/etc,g' docs/esd.1

%make DESTDIR=%buildroot install

%files -n esd
%_bindir/esd
%_bindir/esddsp
%_bindir/esdplay
%_man1dir/esd.*
%_man1dir/esddsp.*
%config(noreplace) %_sysconfdir/esd.conf

%files -n libesd
%_libdir/*.so.*
%doc AUTHORS NEWS README TIPS MAINTAINERS

%files utils
%_bindir/*
%exclude %_bindir/esd
%exclude %_bindir/esddsp
%exclude %_bindir/esd-config
%exclude %_bindir/esdplay
%_man1dir/*.1*
%exclude %_man1dir/esd.1*
%exclude %_man1dir/esddsp.1*
%exclude %_man1dir/esd-config.1*

%files -n libesd-devel
%_bindir/esd-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*
%_datadir/aclocal/*
%_man1dir/esd-config.1*
%doc ChangeLog TODO TIPS docs/html

%if_enabled static
%files -n libesd-devel-static
%_libdir/*.a
%endif

# packaged as %doc
%exclude %_datadir/doc/esound

%changelog
