Name:		etcnet
Version:	0.9.10
Release:	alt17.M70P.1

Summary:	/etc/net network configuration system
License:	GPL-2
Group:		System/Base

Source:		%name-%version.tar

PreReq:		setup >= 0:2.1.9-ipl18mdk, service, startup >= 0:0.9.3-alt1
Requires:	grep, sed, iproute2, ifrename >= 28-alt5.pre10, chkconfig
Requires:	etcnet-defaults = %version-%release

BuildArch:	noarch

Conflicts:	net-scripts
Conflicts:	ethtool < 0:3-alt4, ifplugd < 0.28-alt2, ipset < 4.1-alt2
Provides:	network-config-subsystem

%description
/etc/net represents a new approach to Linux network configuration tasks.
Inspired by the limitations of traditional network configuration subsystems,
/etc/net provides builtin support for configuration profiles, interface name
management, removable devices, full iproute2 command set, interface
dependencies resolution, QoS and firewall configuration frameworks.
/etc/net provides support for the following interface types: Ethernet, WiFi
(WEP), IPv4/IPv6 tunnels, PSK IPSec tunnels, VLAN, PLIP, Ethernet bonding and
bridging, traffic equalizer, Pent@NET, Pent@VALUE, SkyStar-2, TUN/TAP,
OpenVPN TUN/TAP, OpenSSH TUN/TAP, usbnet and PPP. Due to its modular structure,
support for new interface types can be added without overall design changes.

%package full
Summary:	/etc/net plus everything it can work with
Group:		System/Configuration/Networking
Requires:	%name = %version-%release, wireless-tools
Requires:	dhcpcd >= 1.3.22pl4-alt3, iptables, iptables-ipv6, ebtables, ipset >= 4.1-alt2
Requires:	ethtool >= 0:3-alt4, ifplugd >= 0.28-alt2
Requires:	hotplug, ncpfs, ppp, vlan-utils, bridge-utils, openvpn, tunctl
Requires:	pptp-client, wpa_supplicant, avahi-autoipd, rp-pppoe-base >= 3.6-alt2

%description full
This virtual package requires /etc/net and all packages that may appear useful
for /etc/net. Accurate requirements should result in correct package versions
in ALTLinux system.

%package defaults-desktop
Summary:	/etc/net defaults for a Linux desktop
Group:		System/Configuration/Networking
Provides:	%name-defaults = %version-%release
Conflicts:	%name-defaults-server
Requires:	%name = %version-%release

%description defaults-desktop
This package contains default options for a Linux desktop.


%package defaults-server
Summary:	/etc/net defaults for a Linux server
Group:		System/Configuration/Networking
Provides:	%name-defaults = %version-%release
Conflicts:	%name-defaults-desktop
Requires:	%name = %version-%release

%description defaults-server
This package contains default options for a Linux server.

%prep
%setup

%install
# Common part first, distribution-specific files later.
make -f contrib/Makefile prefix=%{buildroot} install
install -m 644 contrib/50-ALTLinux-desktop %buildroot/etc/net/options.d
install -m 644 contrib/50-ALTLinux-server  %buildroot/etc/net/options.d

%post
if [ $1 -eq 1 ]; then
# This is a fresh install.
	/sbin/chkconfig --add network
fi

%preun
if [ $1 -eq 0 ]; then
# This is an erase.
	/sbin/chkconfig --del network
fi

# since 0.5.0 we have 'network' chkconfig entry instead of 'etcnet' one
%triggerun -- %name < 0.5.1
if [ $2 -gt 0 ]; then
# This is etcnet upgrade.
	/sbin/chkconfig --del etcnet
	/sbin/chkconfig --add network
fi

%triggerpostun -- net-scripts
/sbin/chkconfig --add network

# We used to ship some Ruby contrib scripts, but having Ruby installed
# by dependency isn't an idea most normal users would like. So let
# people adjust their environment manually for particular contribs to work.
%add_findreq_skiplist /etc/net/scripts/contrib/*

%files
%dir %_sysconfdir/net
%dir %_sysconfdir/net/scripts
%dir %_sysconfdir/net/ifaces
%dir %_sysconfdir/net/ifaces/default
%dir %_sysconfdir/net/ifaces/lo
%dir %_sysconfdir/net/ifaces/unknown
%dir %_sysconfdir/net/options.d
%_sysconfdir/net/scripts/*
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/net/ifaces/default/*
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/net/ifaces/unknown/*
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/net/ifaces/lo/*
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/net/sysctl.conf
%_initdir/network
%exclude %_sysconfdir/net/options.d/50-*
%config %_sysconfdir/net/options.d/*
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/network
%doc docs/README* docs/ChangeLog docs/TODO docs/wiki-RU/
%doc examples/ contrib/
%_man5dir/*
%_man8dir/*
/sbin/ifup
/sbin/ifdown
/sbin/eqos
/sbin/efw

%files defaults-desktop
%config %_sysconfdir/net/options.d/50-ALTLinux-desktop

%files defaults-server
%config %_sysconfdir/net/options.d/50-ALTLinux-server

%files full

%changelog
