%def_disable static
%def_enable pixman
%define _libexecdir %_prefix/libexec

Name: evas
Version: 1.7.7
%ifdef beta
Release: alt1.%beta
%else
Release: alt1
%endif
Serial: 1

Summary: Multi-platform Canvas Library
License: BSD
Group: System/Libraries
URL: http://www.enlightenment.org

Source: http://download.enlightenment.org/releases/%name-%version.tar.bz2
Patch: evas-1.7.1-alt-build.patch

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildPreReq: libedb-devel >= 1.0.5.007-alt1.20070731
BuildPreReq: libeet-devel >= 1.7.3 libeina-devel >= 1.7.3
BuildRequires: fontconfig-devel libharfbuzz-devel libX11-devel libXrender-devel libXext-devel libICE-devel libGL-devel
%ifarch %arm
BuildRequires: libEGL-devel libGLES-devel
%endif
BuildRequires: libungif-devel libpng-devel libjpeg-devel
BuildRequires: libtiff-devel libcairo-devel libSDL-devel
%{?_enable_pixman:BuildRequires: libpixman-devel}
BuildRequires: doxygen

%description
Evas is a clean display canvas API for several target display systems that
can draw anti-aliased text, smooth super and sub-sampled scaled images,
alpha-blend objects much and more.

%package -n lib%name
Summary: Enlightened Canvas Library
Group: System/Libraries

%description -n lib%name
Evas is a clean display canvas API for several target display systems that
can draw anti-aliased text, smooth super and sub-sampled scaled images,
alpha-blend objects much and more.

%package -n lib%name-devel
Summary: Enlightened Canvas Library development files
Group: Development/C
Requires: lib%name = %serial:%version-%release

%description -n lib%name-devel
Enlightened Canvas Library headers and development libraries.

%package -n lib%name-devel-static
Summary: Static version of Enlightened Canvas Library
Group: Development/C
Requires: lib%name-devel = %serial:%version-%release

%description -n lib%name-devel-static
This package contains library needed to build applications statically
linked with Enlightened Canvas Library.

%package -n lib%name-doc
Summary: Enlightened Canvas Library development documentation
Group: Books/Computer books
Conflicts: lib%name < %serial:%version-%release
BuildArch: noarch

%description -n lib%name-doc
This package contains Enlightened Canvas Library development
documentation

%define customdocdir %_docdir/lib%name-%version

%prep
%ifdef cvs_date
%setup -q -n %name
%else
%setup -q -n %name-%version
%endif

%patch -p1

%build
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure \
	--enable-image-loader-gif \
	--enable-image-loader-png \
	--enable-image-loader-jpeg \
	--enable-image-loader-xpm \
	--enable-image-loader-svg \
	--enable-image-loader-eet \
	--enable-image-loader-edb \
	--enable-pthreads \
%ifarch %ix86 x86_64
	--enable-cpu-mmx \
	--enable-cpu-sse \
%endif
%ifarch %arm
	--enable-gl-flavor-gles \
	--enable-gles-variety-sgx \
	--enable-gl-xlib \
%endif
	--enable-cpu-c \
	--enable-scale-smooth \
	--enable-scale-sample \
	--enable-convert-8-rgb-332 \
	--enable-convert-8-rgb-666 \
	--enable-convert-8-rgb-232 \
	--enable-convert-8-rgb-222 \
	--enable-convert-8-rgb-221 \
	--enable-convert-8-rgb-121 \
	--enable-convert-8-rgb-111 \
	--enable-convert-16-rgb-565 \
	--enable-convert-16-rgb-555 \
	--enable-convert-16-rgb-rot-0 \
	--enable-convert-16-rgb-rot-90 \
	--enable-convert-16-rgb-rot-270 \
	--enable-convert-32-rgb-8888 \
	--enable-convert-32-rgbx-8888 \
	--enable-convert-32-bgr-8888 \
	--enable-convert-32-bgrx-8888 \
	--enable-convert-32-rgb-rot-0 \
	--enable-convert-32-rgb-rot-90 \
	--enable-convert-32-rgb-rot-270 \
	%{subst_enable pixman} \
	%{subst_enable static}

	#--enable-gl-glew \
	#--enable-gl-sdl \
	#--enable-gl-xlib \

%make_build
%make doc

%install
%makeinstall

rm -rf %buildroot%_datadir/%name/doc
mkdir -p %buildroot%customdocdir
cp -R doc %buildroot%customdocdir

%files -n lib%name
%_bindir/evas_cserve2_client
%_bindir/evas_cserve2_debug
%_bindir/evas_cserve2_usage
%_libexecdir/dummy_slave
%_libexecdir/evas_cserve2
%_libexecdir/evas_cserve2_slave
%_libdir/*.so.*
%_libdir/evas
%_datadir/evas/checkme

%files -n lib%name-devel
%_includedir/*
%_pkgconfigdir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n lib%name-doc
%customdocdir

%exclude %_datadir/evas/examples/evas-buffer-simple.c

%changelog
