%define ver_major 3.8
%define ver_base 3.8
%define gst_api_ver 1.0

%def_disable static
%def_enable gtk_doc
%def_with openldap
%def_disable static_ldap
%def_with krb5
%def_disable map
%def_disable image_inline
%def_enable goa

# %define plugins experimental
%define plugins all

# Use stricter build settings than required by upstream.
%define strict_build_settings 1

Name: evolution
Version: %ver_major.4
Release: alt1

Summary: Integrated GNOME mail client, calendar and address book
License: GPLv2+
Group: Office
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
Url: http://www.gnome.org/projects/%name/

#Source: %name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

### Patches ###
# hack to properly link against ldap libs
Patch10: evolution-3.0.3-ldap_libs.patch
# RH bug #176400
Patch27: evolution-2.9.1-im-context-reset.patch

%define evo_plugin_dir %_libdir/evolution/%ver_base/plugins
%define evo_module_dir %_libdir/evolution/%ver_base/modules

Provides: camel

# from configure.in
%define glib_ver 2.30.0
%define gtk_ver 3.2
%define clutter_gtk_ver 0.91.8
%define eds_ver 3.8.4
%define gnome_icon_ver 3.0.0
%define gnome_desktop_ver 2.91.6
%define gtkhtml_ver 4.5.2
%define libsoup_ver 2.40.3
%define libnotify_ver 0.7.0
%define gweather_ver 3.5.0
%define ical_ver 0.43
%define gdata_ver 0.10.0
%define champlain_ver 0.12
%define goa_ver 3.1.1
%define pst_ver 0.6.54
%define webkit_ver 1.10.0
%define geocode_ver 0.99.0

Requires: %name-data = %version-%release
Requires: evolution-data-server >= %eds_ver
Requires: gnome-settings-daemon
Requires: highlight

BuildPreReq: gnome-common
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgail3-devel >= %gtk_ver
BuildPreReq: gnome-icon-theme >= %gnome_icon_ver
BuildPreReq: evolution-data-server-devel >= %eds_ver
BuildPreReq: libgtkhtml4-devel >= %gtkhtml_ver
BuildPreReq: libgnome-desktop3-devel >= %gnome_desktop_ver
BuildPreReq: libsoup-gnome-devel >= %libsoup_ver
BuildPreReq: libnotify-devel >= %libnotify_ver
BuildPreReq: libgweather-devel >= %gweather_ver
BuildPreReq: NetworkManager-devel >= 0.8.997
BuildPreReq: libical-devel >= %ical_ver
BuildPreReq: libgdata-devel >= %gdata_ver
BuildPreReq: libpst-devel >= %pst_ver
BuildPreReq: libwebkitgtk3-devel >= %webkit_ver
BuildPreReq: libclutter-gtk3-devel >= %clutter_gtk_ver
%{?_enable_goa:BuildPreReq: libgnome-online-accounts-devel >= %goa_ver}
%{?_enable_map:BuildPreReq: libchamplain-gtk3-devel >= %champlain_ver libgeoclue-devel libgeocode-glib-devel >= %geocode_ver}
%{?_enable_image_inline:BuildRequires: libgtkimageview-devel}

BuildRequires: docbook-utils intltool yelp-tools itstool gtk-doc
BuildRequires: gcc-c++ flex libSM-devel libcom_err-devel gstreamer%gst_api_ver-devel
BuildRequires: python-modules-compiler python-modules-encodings libnspr-devel libnss-devel libX11-devel libcanberra-gtk3-devel
BuildRequires: zlib-devel libxml2-devel

# Some plugins/extensions link with others, resulting in multiple rpath entries
%set_verify_elf_method rpath=relaxed

%if_with krb5
BuildRequires: libkrb5-devel
%endif

%if_with openldap
BuildRequires: libldap-devel
%if_enabled static_ldap
BuildRequires: libldap-devel-static libssl-devel libsasl2-devel.
%endif
%endif

%description
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

%package data
Summary: Evolution data files
Group: Office
BuildArch: noarch

%description data
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains common noarch files needed for  Evolution.

%package bogofilter
Group: Networking/Mail
Summary: Bogofilter plugin for Evolution
Requires: %name = %version-%release
Requires: bogofilter

%description bogofilter
This package contains the plugin to filter junk mail using Bogofilter.

%package spamassassin
Group: Networking/Mail
Summary: SpamAssassin plugin for Evolution
Requires: %name = %version-%release
Requires: spamassassin

%description spamassassin
This package contains the plugin to filter junk mail using SpamAssassin.

%package devel
Summary: Evolution development files
Group: Development/C
Requires: %name = %version-%release
Requires: evolution-data-server-devel >= %eds_ver

%description devel
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains files needed to develop Evolution plugins.

%package devel-doc
Summary: Evolution development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Evolution is the GNOME mailer, calendar, contact manager and
communications tool. The tools which make up Evolution will
be tightly integrated with one another and act as a seamless
personal information-management tool.

This package contains documentation needed to develop Evolution plugins.

%add_findprov_lib_path %_libdir/%name/%ver_base

%define _libexecdir %_prefix/libexec

%prep
%setup -q
%patch10 -b .ldaphack
%patch27 -p1 -b .im-context-reset

%__subst '/use diagnostics/d' addressbook/tools/csv2vcard.in
subst 's,(Unstable),,' data/evolution.desktop*

# Remove the welcome email from Novell
for inbox in mail/default/*/Inbox; do
  echo -n "" > $inbox
done

# remove pregenerated .desktop files
rm -f data/*.desktop{,.in}

%build
%if_with openldap
%if_enabled static_ldap
%define ldap_flags --with-openldap=yes --with-static-ldap
# Set LIBS so that configure will be able to link with static LDAP libraries,
# which depend on Cyrus SASL and OpenSSL.  XXX Is the "else" clause necessary?
if pkg-config openssl ; then
    export LIBS="-lsasl2 `pkg-config --libs openssl`"
else
export LIBS="-lsasl2 -lssl -lcrypto"
fi
%else
%define ldap_flags --with-openldap=yes
%endif
%else
%define ldap_flags --without-openldap
%endif
export CPPFLAGS="-I%{_includedir}/et"
export CFLAGS="$RPM_OPT_FLAGS -fPIC -I%{_includedir}/et -Wno-sign-compare"

# Add stricter build settings here as the source code gets cleaned up. 
# We want to make sure things like compiler warnings and avoiding deprecated 
# functions in the GNOME/GTK+ libraries stay fixed. 
# 
# Please file a bug report at bugzilla.gnome.org if these settings break 
# compilation, and encourage the upstream developers to use them. 

%if %{strict_build_settings}
CFLAGS="$CFLAGS \
	-UGNOME_DISABLE_DEPRECATED \
	-fno-strict-aliasing"
%endif

#NOCONFIGURE=1 ./autogen.sh
%autoreconf
export ac_cv_path_BOGOFILTER=%_bindir/bogofilter
export ac_cv_path_SENDMAIL=%_sbindir/sendmail
export ac_cv_path_SPAMASSASSIN=%_bindir/spamassassin
export ac_cv_path_SA_LEARN=%_bindir/sa-learn
export ac_cv_path_HIGHLIGHT=%_bindir/highlight
export KILL_PROCESS_CMD=%_bindir/killall
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %ldap_flags \
    --with-sub-version=" (%version-%release)" \
    --enable-plugins=%plugins \
    --enable-nss \
    --enable-smime \
    --enable-audio-inline \
%if_with krb5
    --with-krb5=%_prefix \
    --with-krb5-libs=%_libdir \
    --with-krb5-includes=%_includedir/krb5 \
%endif
    --disable-schemas-compile \
    %{?_enable_map:--enable-contact-maps} \
    %{subst_enable goa} \
    %{?_disable_image_inline:--disable-image-inline}

%make_build
#CFLAGS="$CFLAGS -UGNOME_DISABLE_DEPRECATED"

%install
%make DESTDIR=%buildroot install

# evolution command name
%__mv %buildroot%_bindir/evolution %buildroot%_bindir/evolution-%ver_major
%__ln_s evolution-%ver_major %buildroot%_bindir/evolution

# remove non-packaged files
%__rm -f %buildroot%_libdir/%name/%ver_base/*.la
%__rm -f %buildroot%_libdir/%name/%ver_base/*/*.la

# temporarily fix for other applications that requires thease libraries
for f in %buildroot%_libdir/%name/%ver_base/{libeshell*,libeutil*}; do
%__ln_s %name/%ver_base/`basename $f` %buildroot%_libdir/`basename $f`
done

# remove scrollkeeper files 
rm -rf %buildroot%_localstatedir/scrollkeeper

%find_lang --with-gnome --output=%name.lang %name %name-%ver_base

%files
%_bindir/*
%_libdir/%name/
%_libexecdir/%name/%ver_base/csv2vcard
%_libexecdir/%name/%ver_base/evolution-addressbook-export
%_libexecdir/%name/%ver_base/evolution-alarm-notify
%_libexecdir/%name/%ver_base/evolution-backup
%_libexecdir/%name/%ver_base/killev
%doc AUTHORS ChangeLog NEWS README

%exclude %evo_module_dir/module-bogofilter.so
%exclude %evo_module_dir/module-spamassassin.so

%files data -f %name.lang
%_sysconfdir/xdg/autostart/evolution-alarm-notify.desktop
%_datadir/applications/*
%_datadir/%name/
%_datadir/glib-2.0/schemas/org.gnome.evolution.addressbook.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.importer.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.mail.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.attachment-reminder.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.autocontacts.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.email-custom-header.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.external-editor.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.face-picture.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.itip.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.mail-notification.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.prefer-plain.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.publish-calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.plugin.templates.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.shell.gschema.xml
%_datadir/GConf/gsettings/evolution.convert
%_iconsdir/hicolor/*/*/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%files devel-doc
%_datadir/gtk-doc/html/*

%files bogofilter
%evo_module_dir/module-bogofilter.so
%_datadir/glib-2.0/schemas/org.gnome.evolution.bogofilter.gschema.xml

%files spamassassin
%evo_module_dir/module-spamassassin.so
%_datadir/glib-2.0/schemas/org.gnome.evolution.spamassassin.gschema.xml

%changelog
