%define ver_major 3.8
%define ver_base 3.8
%define ver_lib 1.2

%def_disable debug
%def_disable static
%def_with sys_db4
%def_with openldap
%def_disable static_ldap
%def_with krb5
%def_enable nntp
%def_enable goa
# Ubuntu online accounts support
%def_disable uoa
%def_enable gtk_doc
%def_enable introspection
%def_enable vala

Name: evolution-data-server
Version: %ver_major.4
Release: alt1

Summary: Evolution Data Server
License: %lgpl2plus
Group: Graphical desktop/GNOME
URL: http://www.gnome.org/projects/evolution/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar
Patch1: %name-1.4.2.1-debug-lock.patch

# from configure.in
%define glib_ver 2.34.0
%define gtk3_ver 3.2.0
%define libsoup_ver 2.33.90
%define gcr_ver 3.4
%define secret_ver 0.5
%define sqlite_ver 3.5
%define gweather_ver 2.91.6
%define ical_ver 0.43
%define gdata_ver 0.10
%define goa_ver 3.7.90
%define vala_ver 0.13.1

BuildPreReq: gcc-c++ rpm-build-gnome rpm-build-licenses intltool
BuildPreReq: gtk-doc >= 1.0
BuildPreReq: gnome-common
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk3_ver
BuildPreReq: libxml2-devel
BuildPreReq: libsoup-devel >= %libsoup_ver
BuildPreReq: libsqlite3-devel >= %sqlite_ver
BuildPreReq: libgweather-devel >= %gweather_ver
BuildPreReq: libical-devel >= %ical_ver
BuildPreReq: libgdata-devel >= %gdata_ver
BuildPreReq: libsecret-devel >= %secret_ver
BuildPreReq: gcr-libs-devel >= %gcr_ver
BuildRequires: gperf docbook-utils flex bison libcom_err-devel libnss-devel libnspr-devel zlib-devel
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver liboauth-devel libgdata-devel >= %gdata_ver}
%{?_enable_uoa:BuildRequires: libaccounts-glib-devel}
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel}
%{?_with_sys_db4:BuildRequires: libdb4-devel}
%{?_with_krb5:BuildRequires: libkrb5-devel}
%{?_enable_vala:BuildPreReq: vala >= %vala_ver vala-tools >= %vala_ver}

%if_with openldap
BuildRequires: libldap-devel
%if_enabled static_ldap
BuildRequires: libldap-devel-static libssl-devel libsasl2-devel
%endif
%endif

%description
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

%package devel
Summary: Development files for Evolution Data Server
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides development files for Evolution Data Server

%package devel-doc
Summary: Development documentation for Evolution Data Server
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

This package contains development documentation for Evolution Data Server.

%package gir
Summary: GObject introspection data for the EDS
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Evolution Data Server libraries

%package gir-devel
Summary: GObject introspection devel data for the EDS
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Evolution Data Server libraries

%package vala
Summary: Vala language bindings for the EDS libraries
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides Vala language bindings for the EDS libraries


%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec/%name

%add_findprov_lib_path %_libdir/%name-%ver_lib/extensions

%prep
%setup -q
%if_enabled debug
%patch1 -p1
%endif

%if_with sys_db4
rm -rf libdb
%__subst '/libdb\/Makefile/d' configure.ac
%__subst 's/^\(SUBDIRS.*\)\$(LIBDB)/\1/' Makefile.am
%endif

%build
%if_with openldap 
%if_enabled static_ldap
%define ldap_flags --with-openldap=yes --with-static-ldap 
# Set LIBS so that configure will be able to link with static LDAP libraries, 
# which depend on Cyrus SASL and OpenSSL.  XXX Is the "else" clause necessary? 
if pkg-config openssl ; then
        export LIBS="-lsasl2 `pkg-config --libs openssl`"
else
        export LIBS="-lsasl2 -lssl -lcrypto"
fi
%else
%define ldap_flags --with-openldap=yes
%endif
%else
%define ldap_flags --without-openldap
%endif

export CPPFLAGS="-I%{_includedir}/et"
export CFLAGS="$RPM_OPT_FLAGS -DLDAP_DEPRECATED -fPIC -I%{_includedir}/et"

%autoreconf
export ac_cv_path_SENDMAIL=%_sbindir/sendmail
export CAMEL_LOCK_HELPER_GROUP=mail
%configure \
%if_enabled debug
    --with-e2k-debug \
%endif
%if_with sys_db4
    --with-libdb=%_prefix \
%endif
    %{subst_enable static} \
    --enable-file-locking=fcntl \
    --enable-dot-locking=no \
    %ldap_flags \
    %{subst_enable nntp} \
    %{subst_enable goa} \
    %{subst_enable uoa} \
    --enable-smime \
%if_with krb5
    --with-krb5=%_prefix \
    --with-krb5-libs=%_libdir \
    --with-krb5-includes=%_includedir/krb5 \
%endif
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    --disable-schemas-compile \
    %{?_enable_vala:--enable-vala-bindings}


%make_build

%install
%make_install DESTDIR=%buildroot install

# if unstable
ln -s camel-lock-helper-1.2 %buildroot%_libexecdir/camel-lock-helper

# remove none-packaged files
rm -f %buildroot%_libdir/%name-%ver_lib/*/*.la

%find_lang --with-gnome --output=%name.lang %name-%ver_base

%files -f %name.lang
%dir %_libexecdir
%_libexecdir/*
%dir %_libdir/%name/addressbook-backends
%dir %_libdir/%name/calendar-backends
%dir %_libdir/%name/camel-providers
%_libdir/%name/*/*.so
%_libdir/%name/*/*.urls
%_libdir/*.so.*
%_datadir/%name/
%_datadir/dbus-1/services/*
%_datadir/pixmaps/*
%_datadir/GConf/gsettings/libedataserver.convert
%_datadir/GConf/gsettings/evolution-data-server.convert
%_datadir/glib-2.0/schemas/org.gnome.Evolution.DefaultSources.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.addressbook.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.eds-shell.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.shell.network-config.gschema.xml
%doc AUTHORS NEWS README MAINTAINERS

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%files devel-doc
%_gtk_docdir/*

%exclude %_libdir/%name/*/*.la

%if_enabled introspection
%files gir
#%_typelibdir/ECalendar-1.2.typelib
%_typelibdir/EBookContacts-1.2.typelib
%_typelibdir/EDataServer-1.2.typelib
%_typelibdir/EBook-1.2.typelib

%files gir-devel
#%_girdir/ECalendar-1.2.gir
%_girdir/EBookContacts-1.2.gir
%_girdir/EDataServer-1.2.gir
%_girdir/EBook-1.2.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/*.deps
%_datadir/vala/vapi/*.vapi
%endif


%changelog
