# Conditional build:
%def_with pgsql	# with PostgreSQL support
%def_with mysql	# with MySQL support
%def_with ldap	# with LDAP support
%def_with heavy	# with all features included

%define ftpurl ftp://ftp.exim.org/pub/exim/exim4
%define openssldir /var/lib/ssl

Name: exim
Version: 4.76
Release: alt3

Summary: Exim Mail Transport Agent
License: GPLv2+
Group: System/Servers

URL: http://www.exim.org/
Source0: %ftpurl/exim-%version.tar.bz2

Source7: %ftpurl/config.samples.tar.bz2

Source9: exim.init
Source10: exim.logrotate
Source101: exim.sysconfig
Source11: eximon.desktop
Source12: exim_aliases
Source13: exim.aliases
Source14: exim.cron
Source15: eximclean
Source18: exim.pam
Source19: exim-altdefault.conf
Source21: eximon.conf
Source22: exim-addMakefile.heavy
Source23: exim-addMakefile.ldap
Source24: exim-addMakefile.mysql
Source25: exim-addMakefile.pgsql
Source26: exim-addMakefile.light
Source31: oview.txt
Source32: oview.ps
Source33: oview.pdf
Source34: oview.texinfo
Source36: README.ALT

Source38: eximon.png
Source43: smtpauthpwd

Patch1: exim-4.72-buildoptions.patch
Patch3: exim-4.34-texinfo.patch
Patch4: exim-4.76-pcre.patch
Patch5: CVE-2012-5671.patch

# Automatically added by buildreq on Tue Apr 26 2011
# ...and edited:
# - to move non-core dependencies to separate lines
# - to separate versioned build requirements
# optimized out: libICE-devel libSM-devel libX11-devel libXmu-devel libXt-devel libcom_err-devel libkrb5-devel libpq-devel xorg-xproto-devel
BuildRequires: libXaw-devel libXext-devel libdb4-devel libpam-devel libpcre-devel libsqlite3-devel libssl-devel libwrap-devel perl-devel

BuildRequires: libspf2-devel > 1.0.4
BuildRequires: libsrs_alt-devel > 0.5

BuildRequires: perl-Pod-Parser

# needed for all builds except -light
BuildRequires: libwhoson-devel libsasl2-devel

# comment next line if you build --without ldap
BuildRequires: libldap-devel

# comment next line if you build --without mysql
BuildRequires: libmysqlclient-devel

# comment next line if you build --without pgsql
BuildRequires: postgresql-devel libpq-devel

# comment next line if you build --without heavy
BuildRequires: libldap-devel libMySQL-devel postgresql-devel libpq-devel

# package %name is virtual package. It depends on exim-common and exim-light
Requires: %name-common = %version-%release
Requires: %name-light = %version-%release

%description 
Smail like Mail Transfer Agent with single configuration file.
Features: flexible retry algorithms, header & envelope rewriting,
multiple deliveries down single connection or multiple deliveries in
parallel, regular expressions in configuration parameters, file
lookups, supports sender and/or reciever verification, selective
relaying, supports virtual domains, built-in mail filtering and can be
configured to drop root privilleges when possible.
It is virtual package. It requires an exim-common and exim-light

%package common
Summary: Exim MTA
Group: System/Servers

Provides: smtpdaemon, smtpd, MTA, MailTransferAgent
#Requires: exim-mta
#Requires: perl-base libpam0 libwrap libdb4.2 libssl
# libwhoson whoson-server
Requires: exim-control
Requires: sendmail-common
# Required for generation of certificates at install time
Requires(post): openssl

%description common
Smail like Mail Transfer Agent with single configuration file.
Features: flexible retry algorithms, header & envelope rewriting,
multiple deliveries down single connection or multiple deliveries in
parallel, regular expressions in configuration parameters, file
lookups, supports sender and/or reciever verification, selective
relaying, supports virtual domains, built-in mail filtering and can be
configured to drop root privilleges when possible.

%package monitor
Summary: Exim - Exceptional Internet Mailer - X mail monitor
Group: Monitoring
Requires: %name-common = %version-%release

%description monitor
X Window based monitor & administration utility for the Exim Mail
Transfer Agent.

%package light
Summary: Main exim MTA program, compiled with basic libraries
Group: System/Servers
Provides: exim-mta, smtpd, smtpdaemon
Provides: %name-light = %version-%release
Provides: /usr/sbin/exim
Conflicts: exim-mysql, exim-pgsql, exim-heavy, exim-ldap
PreReq:	%name-common = %version-%release

%description light
The main exim MTA program, compiled with all basic dbm lookups support,
TLS (SSL) and all the main transports.  This should suit all general
purpose systems, and is the smallest binary.

%package mysql
Summary: Main exim MTA program, compiled with basic libraries + perl + mysql
Group: System/Servers
Provides: exim-mta
Provides: /usr/sbin/exim
Conflicts: exim-light,  exim-pgsql, exim-heavy, exim-ldap
PreReq:	%name-common = %version-%release

Requires(post,preun): %__subst

%description mysql
The main exim MTA program, compiled with all basic dbm lookups support,
TLS (SSL) and all the main transports, plus embedded perl support
and mysql db lookup support.

%package pgsql
Summary: Main exim MTA program, compiled with basic libraries + perl + pgsql
Group: System/Servers
Provides: exim-mta
Provides: /usr/sbin/exim
Conflicts: exim-light, exim-mysql, exim-heavy, exim-ldap
PreReq:	%name-common = %version-%release

%description pgsql
The main exim MTA program, compiled with all basic dbm lookups support,
TLS (SSL), LDAP and all the main transports, plus embedded perl support
and postgresql lookups.

%package heavy
Summary: Main exim MTA program, compiled with basic libraries + perl + pgsql + MySQL
Group: System/Servers
Provides: exim-mta, smtpd, smtpdaemon
Provides: %name-heavy = %version-%release
Provides: /usr/sbin/exim
Conflicts: exim-light, exim-pgsql, exim-mysql, exim-ldap
PreReq:	%name-common = %version-%release

%description heavy
The main exim MTA program, compiled with all basic dbm lookups support,
TLS (SSL), LDAP and all the main transports, plus embedded perl support
and postgresql and MySQL lookups.

%package ldap
Summary: Main exim MTA program, compiled with basic libraries + perl + ldap
Group: System/Servers
Provides: exim-mta
Provides: /usr/sbin/exim
Conflicts: exim-light, exim-mysql, exim-heavy, exim-pgsql
PreReq:	%name-common = %version-%release

%description ldap
The main exim MTA program, compiled with all basic dbm lookups support,
TLS (SSL), LDAP and all the main transports, plus embedded perl support.

%package utils
Summary: Misc utils for debugging exim
Group: System/Servers
Requires: exim-mta

BuildArch: noarch

%description utils
Misc utils for debugging exim.

%prep
%setup -n exim-%version

cp %SOURCE7 %SOURCE31 %SOURCE32 %SOURCE33 %SOURCE34 %SOURCE36 doc/

install -d Local

%patch1 -p1
# temporarily suspended
#patch3 -p1

%patch4 -p1
%patch5 -p1

install %SOURCE21 Local/eximon.conf

%build
# we build several versions here...
mkdir -p bins
versions="light"
%if_with ldap
versions="ldap $versions"
%endif
%if_with mysql
versions="mysql $versions"
%endif
%if_with pgsql
versions="pgsql $versions"
%endif
%if_with heavy
versions="heavy $versions"
%endif

%define compiledir build-`scripts/os-type`-`scripts/arch-type`

for version in $versions
do
 cat src/EDITME %_sourcedir/exim-addMakefile.$version >Local/Makefile
 make CFLAGS="-I/usr/include/pcre $RPM_OPT_FLAGS -DLDAP_DEPRECATED" FULLECHO='' EXIM_CHMOD=''
 cp %compiledir/exim bins/exim-$version
done

%install
install -d %buildroot{%_bindir,%_sbindir,%_man8dir,%_libdir} \
	%buildroot%_var/{spool/exim/{db,input,msglog},log/exim}

install bins/exim* %buildroot/usr/sbin

install %compiledir/exim_{fixdb,tidydb,dbmbuild,dumpdb,lock} \
	%compiledir/exi{cyclog,next,what} %SOURCE12 %SOURCE15 \
	util/{cramtest.pl,logargs.sh,unknownuser.sh} \
	%compiledir/{exigrep,exim_checkaccess,eximstats,exipick,exiqsumm,exiqgrep} \
	%buildroot%_bindir
install %compiledir/eximon.bin %buildroot%_bindir
install %compiledir/eximon %buildroot%_bindir

install -pD -m755 %_sourcedir/exim.cron %buildroot/etc/cron.daily/exim
install -pD -m755 %_sourcedir/exim.init %buildroot/etc/rc.d/init.d/exim
install -pD -m644 %_sourcedir/exim.sysconfig %buildroot/etc/sysconfig/exim
install	-pD -m644 %_sourcedir/exim.logrotate %buildroot/etc/logrotate.d/exim
install -pD -m644 %_sourcedir/exim.pam %buildroot/etc/pam.d/exim
install -pD -m644 %_sourcedir/exim-altdefault.conf %buildroot/etc/exim/exim.conf
install -pD -m644 %_sourcedir/smtpauthpwd %buildroot/etc/exim/smtpauthpwd
install -pD -m644 doc/exim.8 %buildroot%_man8dir/exim.8

#install %{SOURCE13} %buildroot%{_sysconfdir}/exim/aliases

#ln -sf %{_bindir}/exim %buildroot%{_sbindir}/exim
ln -sf %_sbindir/exim %buildroot%_sbindir/sendmail
#ln -sf %{_sbindir}/exim %buildroot%{_libdir}/sendmail
#ln -sf %_sbindir/exim %buildroot%_sbindir/mailq
ln -sf %_sbindir/exim %buildroot%_sbindir/rsmtp
ln -sf %_sbindir/exim %buildroot%_sbindir/rmail
ln -sf %_sbindir/exim %buildroot%_sbindir/runq

install -pD -m644 %_sourcedir/eximon.desktop %buildroot%_desktopdir/eximon.desktop
install -pD -m644 %_sourcedir/eximon.png %buildroot%_liconsdir/eximon.png

touch %buildroot%_sysconfdir/%name/aliases
ln -sf  %_sysconfdir/%name/aliases %buildroot%_sysconfdir/aliases

pod2man --center=EXIM --section=8 \
	%buildroot%_bindir/eximstats \
	%buildroot%_man8dir/eximstats.8
pod2man --center=EXIM --section=8 \
	%buildroot%_bindir/exipick \
	%buildroot%_man8dir/exipick.8

# generate ghost .pem files
mkdir -p %buildroot%openssldir/{certs,private}
touch %buildroot%openssldir/{certs,private}/exim.pem
chmod 600 %buildroot%openssldir/{certs,private}/exim.pem

%post common
#post_service exim
ALIASES=%_sysconfdir/%name/aliases /usr/share/sendmail-common/rebuild_aliases
#exim_aliases
chown -R mail:mail /var/spool/exim/{db,input,msglog} /var/log/exim

if [ ! -f %openssldir/certs/exim.pem ] ; then
  umask 077
  FQDN=`hostname`
  if [ "x${FQDN}" = "x" ]; then
    FQDN=localhost.localdomain
  fi
  cat << EOF | openssl req -new -x509 -days 365 -nodes -out %openssldir/certs/exim.pem -keyout %openssldir/private/exim.pem 2>/dev/null
--
SomeState
SomeCity
SomeOrganization
SomeOrganizationalUnit
${FQDN}
root@${FQDN}
EOF
chown mail.mail %openssldir/{private,certs}/exim.pem
chmod 600 %openssldir/{private,certs}/exim.pem
fi

%preun common
%preun_service exim

%post light
ln -sf /usr/sbin/exim-light /usr/sbin/exim
%post_service exim

%preun light
%preun_service exim

%if_with mysql
%post mysql
ln -sf /usr/sbin/exim-mysql /usr/sbin/exim
%post_service exim

%preun mysql
%preun_service exim
%endif

%if_with pgsql
%post pgsql
ln -sf /usr/sbin/exim-pgsql /usr/sbin/exim
%post_service exim

%preun pgsql
%preun_service exim
%endif

%if_with heavy
%post heavy
ln -sf /usr/sbin/exim-heavy /usr/sbin/exim
%post_service exim

%preun heavy
%preun_service exim
%endif

%if_with ldap
%post ldap
ln -sf /usr/sbin/exim-ldap /usr/sbin/exim
%post_service exim

%preun ldap
%preun_service exim
%endif

%files

%files common
%doc ACKNOWLEDGMENTS NOTICE README.UPDATING
%doc doc/{README.SIEVE,ChangeLog,NewStuff,dbm.discuss.txt,filter.txt,oview.txt,spec.txt}
%doc doc/experimental-spec.txt
%doc doc/{OptionLists.txt,config.samples.tar.bz2,pcre*.txt}
#%doc util/transport-filter.pl

%config(noreplace) %_sysconfdir/exim/exim.conf
%attr(400,mail,mail) %config(noreplace) %_sysconfdir/exim/smtpauthpwd
%ghost %attr( 644,root,root) %config(noreplace) %_sysconfdir/exim/aliases
%_sysconfdir/aliases
%config(noreplace) /etc/sysconfig/exim
%config(noreplace) /etc/logrotate.d/exim
%config %_initdir/exim
%config(noreplace) /etc/pam.d/exim
%config /etc/cron.daily/exim
%attr(0600,root,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) %openssldir/certs/exim.pem
%attr(0600,root,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) %openssldir/private/exim.pem
#%attr(4755,exim,exim) %{_bindir}/exim

%_bindir/exim_*
%_bindir/exinext
%_bindir/exiwhat
%_bindir/exicyclog
%_bindir/exigrep
%_bindir/eximstats
%_bindir/exiqsumm
%_bindir/exiqgrep
#%attr( 755,root,root) %{_sbindir}/exim
#_sbindir/mailq
%_sbindir/rmail
%_sbindir/rsmtp
%_sbindir/runq
%_sbindir/sendmail
%_man8dir/*

%attr(770,root,mail) %dir %_var/spool/exim
%attr(750,mail,mail) %dir %_var/spool/exim/db
%attr(700,mail,mail) %dir %_var/spool/exim/input
%attr(750,mail,mail) %dir %_var/spool/exim/msglog
%attr(750,mail,mail) %dir %_var/log/exim

%files monitor
%_bindir/eximon*
%_desktopdir/*
%_liconsdir/*

%files light
%attr(4711,root,root)/usr/sbin/exim-light
#%ghost /usr/sbin/exim


%if_with mysql
%files mysql
%attr(4711,root,root)/usr/sbin/exim-mysql
#%ghost /usr/sbin/exim
%endif

%if_with pgsql
%files pgsql
%attr(4711,root,root)/usr/sbin/exim-pgsql
#%ghost /usr/sbin/exim
%endif

%if_with ldap
%files ldap
%attr(4711,root,root)/usr/sbin/exim-ldap
#%ghost /usr/sbin/exim
%endif


%if_with heavy
%files heavy
%attr(4711,root,root)/usr/sbin/exim-heavy
#%ghost /usr/sbin/exim
%endif

%files utils
%_bindir/cramtest.pl
%_bindir/logargs.sh
%_bindir/unknownuser.sh
%_bindir/eximclean
%_bindir/exipick

%changelog
