Name: expect
Version: 5.45
Release: alt4
Serial: 1

Summary: A tcl extension for simplifying program-script interaction
License: BSD
Group: Development/Tcl
Url: http://expect.nist.gov/

Source0: %name-%version-%release.tar

BuildRequires: tcl-devel >= 8.5.0-alt1
BuildRequires(pre): /dev/pts
BuildRequires(pre): /proc

Requires: tcl >= 8.5.0-alt0.3
Requires: /proc

%package devel
Summary: Expect header files and lib%name manpage
Group: Development/C
Requires: %name = %serial:%version-%release tcl-devel >= 8.5.0-alt0.3

%package examples
Summary: Example applications using Expect
Group: Development/Tcl
Requires: %name = %serial:%version-%release tcl(Tk)

%description
Expect is a tcl extension for automating interactive applications such
as telnet, ftp, passwd, fsck, rlogin, tip, etc.  Expect is also useful
for testing the named applications.  Expect makes it easy for a script
to control another program and interact with it.

Install the expect package if you'd like to develop scripts which interact
with interactive applications.  You'll also need to install the tcl
package.

%description devel
Expect is a tcl extension for automating interactive applications such
as telnet, ftp, passwd, fsck, rlogin, tip, etc.  Expect is also useful
for testing the named applications.  Expect makes it easy for a script
to control another program and interact with it.

This package provides development environment for expect.

%description examples
Expect is a tcl extension for automating interactive applications such
as telnet, ftp, passwd, fsck, rlogin, tip, etc.  Expect is also useful
for testing the named applications.  Expect makes it easy for a script
to control another program and interact with it.

This package provides example programs found in expect bundle.

%prep
%setup

%build
autoconf
(cd testsuite && aclocal -I .. && autoconf)
export ac_cv_c_tclconfig=%_libdir
export ac_cv_c_tclh=%_includedir/tcl
%configure --disable-rpath
%make_build all test

%install
%make_install DESTDIR=%buildroot install
mv %buildroot%_libdir/%name%version/lib%name%version.so %buildroot%_libdir
ln -sf lib%name%version.so %buildroot%_libdir/lib%name.so
rm -rf %buildroot%_libdir/%name%version
mkdir -p -m0755 %buildroot%_tcldatadir/%name%version
cat <<EOF > %buildroot%_tcldatadir/%name%version/pkgIndex.tcl
package ifneeded Expect %version [list load [file join \$dir .. .. .. %_lib lib%name%version.so]]
EOF

%files
%doc FAQ NEWS README
%_bindir/expect
%_bindir/autoexpect
%_libdir/lib%name%version.so
%_tcldatadir/%name%version
%_man1dir/expect.*
%_man1dir/autoexpect.*

%files devel
%_includedir/*
%_libdir/lib%name.so
%_man3dir/*

%files examples
%_bindir/*
%_man1dir/*
%exclude %_bindir/expect
%exclude %_bindir/autoexpect
%exclude %_man1dir/expect.*
%exclude %_man1dir/autoexpect.*

%changelog
