Name: faces
Version: 1.7.7
Release: alt6.1

Summary: A list monitor with a visual output
License: LGPL
Group: Networking/Mail

Source: ftp://ftp.cs.indiana.edu/pub/%name/%name/%name-%version.tar.bz2

BuildRequires: libgtk+2-devel libICE-devel

%package xface
Summary: Utilities needed by mailers for handling Faces' X-face images
Group: Networking/Mail

%package -n libcompface
Summary: The Faces program's library
Group: System/Libraries

%package -n libcompface-devel
Summary: The Faces program's library and header files
Group: Development/C
Requires: libcompface = %version-%release

# {{{ descriptions
%description
Faces is a program for visually monitoring a list (typically a list of
incoming mail messages, a list of jobs in a print queue or a list of
system users).  Faces operates in five different modes: monitoring for
new mail, monitoring an entire mail file, monitoring a specified print
queue, monitoring users on a machine and custom monitoring.  Faces also
includes a utility for including a face image (a compressed, scanned
image) with mail messages.  The image has to be compressed in a certain
way, which can then be uncompressed and displayed on-the-fly in the mail
program.  This feature of %name is typically used with the exmh mail
handling system.

Install %name if you'd like to use its list monitoring capability or
its face image inclusion capability.  If you would like to include
face images in email, you'll also need to install the %name-xface
package.  If you would like to develop xface applications, you'll need
to also install %name-devel.

%description xface
Faces-xface includes the utilities that mail user agent programs need to
handle X-Face mail headers.  When an email program reads the X-face
header line in an email message, it calls these utilities to display
the face image included in the message.

You'll need to install %name-xface if you want your mail program to
display Faces' X-face images.

%description -n libcompface
%name shared library

%description -n libcompface-devel
libcompface-devel contains the %name program development environment,
(i.e., the static libraries and header files).

# }}}

%prep
%setup
touch config.rpath
sed -i 's|@GT_NO@||g' */Makefile.in
sed -i 's|@GT_YES@|#NO#|g' */Makefile.in

%build
%autoreconf
%configure --disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install
install -pD -m644 faces.xpm %buildroot%_niconsdir/%name.xpm
install -pD -m644 faces.desktop %buildroot%_desktopdir/%name.desktop

%files
%_bindir/compface
%_bindir/uncompface
%_man1dir/compface.1.*
%_man1dir/uncompface.1.*

%files xface
%_bindir/%name
%_man1dir/%name.1.*
%_desktopdir/%name.desktop
%_niconsdir/%name.xpm

%files -n libcompface
%_libdir/*.so.*

%files -n libcompface-devel
%_libdir/*.so
%_includedir/*
%_man3dir/compface.3.*

%changelog
