Name: fakeroot
Version: 1.18.4
Release: alt1

Summary: Run a command in an environment faking root privileges for file manipulation
License: GPLv3+
Group: Development/Other
Url: http://packages.qa.debian.org/f/fakeroot.html

# http://git.altlinux.org/people/ldv/packages/?p=fakeroot.git
Source: %name-%version-%release.tar

Requires: getopt
BuildRequires: gcc-c++, libacl-devel
%{!?_without_check:%{!?_disable_check:BuildRequires: sharutils}}

%description
fakeroot runs a command in an environment were it appears to have root
privileges for file manipulation.  This is useful for allowing users to
createarchives (tar, ar, .rpm etc.) with files in them with root
permissions/ownership.  Without fakeroot one would have to have root
privileges to create the constituent files of the archives with the
correct permissions and ownership, and then pack them up, or one would
have to construct the archives directly, without using the archiver.

%prep
%setup -n %name-%version-%release
echo 'define(FAKEROOT_VERSION, %version)' >acinclude.m4
bzip2 -9fk debian/changelog

%build
grep -FZrl sys: test |
	xargs -r0 sed -i "s/sys:/bin:/g" --
grep -FZrl :sys test |
	xargs -r0 sed -i "s/:sys/:bin/g" --
mkdir build-aux
autoreconf -fisv
%configure --libdir=%_libdir/libfakeroot --enable-static=no
%make_build LIBCPATH=/%_lib/libc.so.6

%check
%make_build -k check

%install
%makeinstall libdir=%buildroot%_libdir/libfakeroot
find %buildroot%_libdir -type f -name \*.la -delete

%files
%_bindir/*
%_libdir/libfakeroot
%_mandir/man?/*
%doc debian/changelog.bz2 doc/README* DEBUG

%changelog
