BuildRequires: desktop-file-utils
%define		git 20110222

Name:		fatrat
Version:	1.1.3
Release:	alt0.2.%git.qa7
Summary:	FatRat is an open source download/upload manager
License: 	GPLv2
Group: 		Networking/File transfer
Packager:	Motsyo Gennadi <drool@altlinux.ru>
Url:		http://fatrat.dolezel.info/
Source0:	http://www.dolezel.info/download/data/%name/%name-%version.tar.gz
Patch0:		%name-1.1.3-fix_old_libtorrent-rasterbar.diff
Patch1: %name-1.1.3-alt-link.diff
Patch2: %name-1.1.3-alt-glibc-2.16.patch
Patch3: %name-1.1.3-alt-torrent.patch
Patch4: %name-1.1.3-alt-boost-1.52.0.patch

Requires:	libqt4-core

# Automatically added by buildreq on Wed Mar 16 2011 (-bi)
BuildRequires: ImageMagick-tools cmake gcc-c++ libcurl-devel libgloox-devel libpion-net-devel libqt4-help libqt4-svg libqt4-webkit libqt4-xmlpatterns phonon-devel

BuildRequires: /usr/bin/qcollectiongenerator-qt4
BuildPreReq: libtorrent-rasterbar7-devel

%description
FatRat is an open source download manager for Linux
written in C++ and built on top of the Trolltech Qt4
library. It is rich in features and is continuously
extended.

%package -n %name-devel
Summary: FatRat header files
Group: Development/C++
# #Requires: %name = %version-%release
BuildArch: noarch

%description -n %name-devel
%name-devel contains the header files needed to develop
programs which make use of FatRat.

%prep
%setup
# #%patch0 -p1
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2

%build
export PATH=$PATH:%_qt4dir/bin
doc/generate.sh
%add_optflags -fpermissive -DBOOST_ASIO_DYN_LINK
cmake \
	-DCMAKE_INSTALL_PREFIX=%_prefix \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DWITH_SFTP=ON \
	-DWITH_BITTORRENT=ON \
	-DWITH_JABBER=ON \
	-DWITH_NLS=ON \
	-DWITH_WEBINTERFACE=ON \
	-DWITH_CURL=ON \
	-DWITH_DOCUMENTATION=ON

%install
%make DESTDIR=%buildroot install VERBOSE=1

# Icons
mkdir -p %buildroot/{%_miconsdir,%_niconsdir,%_liconsdir}
convert -resize 48x48 gfx/%name.png %buildroot%_liconsdir/%name.png
convert -resize 32x32 gfx/%name.png %buildroot%_niconsdir/%name.png
convert -resize 16x16 gfx/%name.png %buildroot%_miconsdir/%name.png
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=FileTransfer \
	%buildroot%_desktopdir/fatrat.desktop

%files
%dir %_datadir/%name
%_bindir/%name
%_bindir/%name-nogui
%_desktopdir/%name.desktop
%_datadir/%name
%_man1dir/%{name}*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_pixmapsdir/%name.png

%files -n %name-devel
%dir %_includedir/%name
%_includedir/%name

%changelog
